/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.interfaces.IProxyPushSupplier;

public class WaitRetryStrategy
extends AbstractRetryStrategy {
    public static final long WAIT_TIME_DEFAULT = 1000L;
    public static final long WAIT_INCREMENT_DEFAULT = 3000L;
    private long currentTimeToWait_;
    private long waitTimeIncrement_;

    public WaitRetryStrategy(IProxyPushSupplier pushSupplier, PushOperation pushOperation) {
        this(pushSupplier, pushOperation, 1000L, 3000L);
    }

    public WaitRetryStrategy(IProxyPushSupplier pushSupplier, PushOperation pushOperation, long startingWaitTime, long waitTimeIncrement) {
        super(pushSupplier, pushOperation);
        this.currentTimeToWait_ = startingWaitTime;
        this.waitTimeIncrement_ = waitTimeIncrement;
    }

    protected long getTimeToWait() {
        long _timeToWait = this.currentTimeToWait_;
        this.currentTimeToWait_ += this.waitTimeIncrement_;
        return _timeToWait;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void retryInternal() throws RetryException {
        while (true) {
            if (!this.isRetryAllowed()) throw new RetryException("no more retries possible");
            try {
                this.pushOperation_.invokePush();
                return;
            }
            catch (Exception error) {
                this.remoteExceptionOccured(error);
                continue;
            }
            break;
        }
        finally {
            this.dispose();
        }
    }
}

