/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.io.InputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;

class IIOPLoopbackInputStream
extends InputStream {
    private static final int BUF_SIZE = 2048;
    private final byte[] buf = new byte[2048];
    private boolean connected;
    private boolean closed;
    private int writerIndex;
    private int readerIndex;

    IIOPLoopbackInputStream() {
    }

    IIOPLoopbackInputStream(IIOPLoopbackOutputStream los) throws IOException {
        this.connect(los);
    }

    synchronized void connect(IIOPLoopbackOutputStream los) throws IOException {
        if (this.connected) {
            throw new IOException("Alread connected");
        }
        this.connected = true;
        los.connect(this);
    }

    public synchronized int read() throws IOException {
        this.checkConnect();
        return this.internalRead();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int val;
        int returnCount;
        this.checkConnect();
        this.checkBuffer(b, off, len);
        for (returnCount = 0; returnCount < len && (val = this.internalRead()) != -1; ++returnCount) {
            b[off + returnCount] = (byte)val;
        }
        return returnCount > 0 ? returnCount : -1;
    }

    public synchronized int available() throws IOException {
        this.checkConnect();
        if (this.writerIndex > this.readerIndex) {
            return this.writerIndex - this.readerIndex;
        }
        if (this.readerIndex > this.writerIndex) {
            return 2048 + this.writerIndex - this.readerIndex;
        }
        this.checkClosed();
        return 0;
    }

    public synchronized void close() throws IOException {
        this.checkConnect();
        this.closed = true;
        this.notifyAll();
    }

    synchronized void writerClose() throws IOException {
        this.checkConnect();
        this.closed = true;
        this.notifyAll();
    }

    synchronized void writeIntoBuffer(int b) throws IOException {
        this.checkConnect();
        this.internalWrite((byte)b);
    }

    synchronized void writeIntoBuffer(byte[] b, int off, int len) throws IOException {
        this.checkConnect();
        this.checkBuffer(b, off, len);
        for (int count = 0; count < len; ++count) {
            this.internalWrite(b[off + count]);
        }
    }

    private int internalRead() {
        while (this.bufferEmpty()) {
            if (this.closed) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {}
        }
        boolean shouldNotify = this.bufferFull();
        int val = this.buf[this.readerIndex] & 0xFF;
        this.readerIndex = this.nextIndex(this.readerIndex);
        if (shouldNotify) {
            this.notifyAll();
        }
        return val;
    }

    private void internalWrite(byte b) throws IOException {
        while (this.bufferFull()) {
            this.checkClosed();
            try {
                this.wait();
            }
            catch (InterruptedException ie) {}
        }
        this.checkClosed();
        boolean shouldNotify = this.bufferEmpty();
        this.buf[this.writerIndex] = b;
        this.writerIndex = this.nextIndex(this.writerIndex);
        if (shouldNotify) {
            this.notifyAll();
        }
    }

    private void checkConnect() throws IOException {
        if (!this.connected) {
            throw new IOException("IIOPLoopbackInputStream not connected");
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("IIOPLoopbackInputStream closed");
        }
    }

    private void checkBuffer(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Null buffer");
        }
        int bufLen = b.length;
        if (off < 0 || off >= bufLen || len < 0 || len > bufLen || off + len > bufLen) {
            throw new IndexOutOfBoundsException("Invalid offset/length");
        }
    }

    private boolean bufferEmpty() {
        return this.readerIndex == this.writerIndex;
    }

    private boolean bufferFull() {
        return this.readerIndex == this.nextIndex(this.writerIndex);
    }

    private int nextIndex(int index) {
        int nextIndex = index + 1;
        return nextIndex == 2048 ? 0 : nextIndex;
    }
}

