/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.logging.Log$class;
import org.infinispan.server.core.transport.ConnectionAdderTask;
import org.infinispan.server.core.transport.Transport;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u00015\u0011aBT3uif$&/\u00198ta>\u0014HO\u0003\u0002\u0004\t\u0005IAO]1ogB|'\u000f\u001e\u0006\u0003\u000b\u0019\tAaY8sK*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011AC5oM&t\u0017n\u001d9b]*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYQ\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!!\u0003+sC:\u001c\bo\u001c:u!\tYb$D\u0001\u001d\u0015\tiB!A\u0004m_\u001e<\u0017N\\4\n\u0005}a\"a\u0001'pO\"Aq\u0001\u0001B\u0001B\u0003%\u0011\u0005\u0005\u0002#G5\tA!\u0003\u0002%\t\tq\u0001K]8u_\u000e|GnU3sm\u0016\u0014\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000f!\fg\u000e\u001a7feB\u0019\u0001fL\u0019\u000e\u0003%R!AK\u0016\u0002\u000f\rD\u0017M\u001c8fY*\u0011A&L\u0001\u0006]\u0016$H/\u001f\u0006\u0002]\u0005\u0011\u0011n\\\u0005\u0003a%\u0012!c\u00115b]:,G.\u00138ji&\fG.\u001b>feB\u0011\u0001FM\u0005\u0003g%\u0012qa\u00115b]:,G\u000e\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003\u001d\tG\r\u001a:fgN\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\n\u0002\u00079,G/\u0003\u0002<q\t\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\t\u0011u\u0002!\u0011!Q\u0001\ny\nQbY8oM&<WO]1uS>t\u0007CA B\u001b\u0005\u0001%BA\u001f\u0005\u0013\t\u0011\u0005IA\u000eQe>$xnY8m'\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0003\r2s!a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u000ba\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111\n\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005#\u0006a1-Y2iK6\u000bg.Y4feB\u0011!+V\u0007\u0002'*\u0011A\u000bC\u0001\b[\u0006t\u0017mZ3s\u0013\t16K\u0001\u000bF[\n,G\rZ3e\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0005\u00061\u0002!\t!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fi[F,\u00180`AB\u0011q\u0003\u0001\u0005\u0006\u000f]\u0003\r!\t\u0005\u0006M]\u0003\ra\n\u0005\u0006k]\u0003\rA\u000e\u0005\u0006{]\u0003\rA\u0010\u0005\u0006\t^\u0003\r!\u0012\u0005\u0006!^\u0003\r!\u0015\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u00039\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYN,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O&\nQa\u001a:pkBL!!\u001b4\u0003'\u0011+g-Y;mi\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\r-\u0004\u0001\u0015!\u0003e\u0003=\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYN\u0004\u0003bB7\u0001\u0005\u0004%\taY\u0001\u0011C\u000e\u001cW\r\u001d;fI\u000eC\u0017M\u001c8fYNDaa\u001c\u0001!\u0002\u0013!\u0017!E1dG\u0016\u0004H/\u001a3DQ\u0006tg.\u001a7tA!9\u0011\u000f\u0001b\u0001\n\u0013\u0011\u0018aC7bgR,'o\u0012:pkB,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m&\n1A\\5p\u0013\tAXOA\tOS>,e/\u001a8u\u0019>|\u0007o\u0012:pkBDaA\u001f\u0001!\u0002\u0013\u0019\u0018\u0001D7bgR,'o\u0012:pkB\u0004\u0003b\u0002?\u0001\u0005\u0004%IA]\u0001\fo>\u00148.\u001a:He>,\b\u000f\u0003\u0004\u007f\u0001\u0001\u0006Ia]\u0001\ro>\u00148.\u001a:He>,\b\u000f\t\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007\t\u0011\u0003^8uC2\u0014\u0015\u0010^3t/JLG\u000f^3o+\t\t)\u0001\u0005\u0003\u0002\b\u0005UQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\r\u0005$x.\\5d\u0015\u0011\ty!!\u0005\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\u0014I\tA!\u001e;jY&!\u0011qCA\u0005\u0005)\tEo\\7jG2{gn\u001a\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0006\u0005\u0011Bo\u001c;bY\nKH/Z:Xe&$H/\u001a8!\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\u0019!\u0001\bu_R\fGNQ=uKN\u0014V-\u00193\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003\u000b\tq\u0002^8uC2\u0014\u0015\u0010^3t%\u0016\fG\r\t\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003S\tA#[:HY>\u0014\u0017\r\\*uCR\u001cXI\\1cY\u0016$WCAA\u0016!\r9\u0015QF\u0005\u0004\u0003_A%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002,\u0005)\u0012n]$m_\n\fGn\u0015;biN,e.\u00192mK\u0012\u0004\u0003bBA\u001c\u0001\u0011\u0005\u0013\u0011H\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003w\u00012aRA\u001f\u0013\r\ty\u0004\u0013\u0002\u0005+:LG\u000fC\u0004\u0002D\u0001!I!!\u000b\u0002!%\u001cHj\\45U\u00063\u0018-\u001b7bE2,\u0007bBA$\u0001\u0011\u0005\u0013\u0011H\u0001\u0005gR|\u0007\u000fC\u0004\u0002L\u0001!\t%!\u0014\u0002)\u001d,G\u000fV8uC2\u0014\u0015\u0010^3t/JLG\u000f^3o)\u0005)\u0005bBA)\u0001\u0011\u0005\u0013QJ\u0001\u0012O\u0016$Hk\u001c;bY\nKH/Z:SK\u0006$\u0007bBA+\u0001\u0011\u0005\u0013qK\u0001\fO\u0016$\bj\\:u\u001d\u0006lW\r\u0006\u0002\u0002ZA\u0019q\"a\u0017\n\u00055\u0003\u0002bBA0\u0001\u0011\u0005\u0013qK\u0001\bO\u0016$\bk\u001c:u\u0011\u001d\t\u0019\u0007\u0001C!\u0003/\nacZ3u\u001dVl'-\u001a:X_J\\WM\u001d+ie\u0016\fGm\u001d\u0005\b\u0003O\u0002A\u0011IA,\u000399W\r^%eY\u0016$\u0016.\\3pkRDq!a\u001b\u0001\t\u0003\n9&A\u0007hKR$6\r\u001d(p\t\u0016d\u0017-\u001f\u0005\b\u0003_\u0002A\u0011IA,\u0003E9W\r^*f]\u0012\u0014UO\u001a4feNK'0\u001a\u0005\b\u0003g\u0002A\u0011IA,\u0003Q9W\r\u001e*fG\u0016Lg/\u001a\"vM\u001a,'oU5{K\"9\u0011q\u000f\u0001\u0005B\u0005e\u0014aG4fi:+XNY3s\u001f\u001adunY1m\u0007>tg.Z2uS>t7\u000f\u0006\u0002\u0002|A\u0019q\"! \n\u0007\u0005}\u0004CA\u0004J]R,w-\u001a:\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002z\u0005ar-\u001a;Ok6\u0014WM](g\u000f2|'-\u00197D_:tWm\u0019;j_:\u001c\b\u0002CAD\u0001\u0011\u0005a!!#\u0002/U\u0004H-\u0019;f)>$\u0018\r\u001c\"zi\u0016\u001cxK]5ui\u0016tG\u0003BA\u001e\u0003\u0017C\u0001\"!$\u0002\u0006\u0002\u0007\u0011qR\u0001\u0006Ef$Xm\u001d\t\u0004\u000f\u0006E\u0015bAAJ\u0011\n\u0019\u0011J\u001c;\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\u0006Q\u0012N\\2sK6,g\u000e\u001e+pi\u0006d')\u001f;fg^\u0013\u0018\u000e\u001e;f]R1\u00111HAN\u0003?C\u0001\"!(\u0002\u0016\u0002\u0007\u0011QA\u0001\u0005E\u0006\u001cX\r\u0003\u0005\u0002\u000e\u0006U\u0005\u0019AAH\u0011!\t\u0019\u000b\u0001C\u0001\r\u0005\u0015\u0016\u0001F;qI\u0006$X\rV8uC2\u0014\u0015\u0010^3t%\u0016\fG\r\u0006\u0003\u0002<\u0005\u001d\u0006\u0002CAG\u0003C\u0003\r!a$\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\u00069\u0012N\\2sK6,g\u000e\u001e+pi\u0006d')\u001f;fgJ+\u0017\r\u001a\u000b\u0007\u0003w\ty+!-\t\u0011\u0005u\u0015\u0011\u0016a\u0001\u0003\u000bA\u0001\"!$\u0002*\u0002\u0007\u0011q\u0012\u0005\b\u0003k\u0003A\u0011BA\\\u0003iqW-\u001a3ESN$(/\u001b2vi\u0016$7)\u00197dk2\fG/[8o)\t\tY\u0003C\u0004\u0002<\u0002!I!!0\u00025\r\fGnY;mCR,w\t\\8cC2\u001cuN\u001c8fGRLwN\\:\u0016\u0005\u0005m\u0004")
public class NettyTransport
implements Transport,
Log {
    private final ChannelInitializer<Channel> handler;
    private final InetSocketAddress address;
    private final ProtocolServerConfiguration configuration;
    private final String threadNamePrefix;
    private final EmbeddedCacheManager cacheManager;
    private final DefaultChannelGroup serverChannels;
    private final DefaultChannelGroup acceptedChannels;
    private final NioEventLoopGroup masterGroup;
    private final NioEventLoopGroup workerGroup;
    private final AtomicLong totalBytesWritten;
    private final AtomicLong totalBytesRead;
    private final boolean isGlobalStatsEnabled;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$server$core$logging$Log$$log$lzycompute() {
        NettyTransport nettyTransport = this;
        synchronized (nettyTransport) {
            if (!this.bitmap$0) {
                this.org$infinispan$server$core$logging$Log$$log = Log$class.org$infinispan$server$core$logging$Log$$log(this);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$server$core$logging$Log$$log;
        }
    }

    @Override
    public JavaLog org$infinispan$server$core$logging$Log$$log() {
        return this.bitmap$0 ? this.org$infinispan$server$core$logging$Log$$log : this.org$infinispan$server$core$logging$Log$$log$lzycompute();
    }

    @Override
    public void info(Function0<String> msg) {
        Log$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Object param1) {
        Log$class.info(this, msg, param1);
    }

    @Override
    public void error(Function0<String> msg, Throwable t) {
        Log$class.error(this, msg, t);
    }

    @Override
    public void warn(Function0<String> msg, Throwable t) {
        Log$class.warn(this, msg, t);
    }

    @Override
    public void debug(Function0<String> msg) {
        Log$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, msg, param1);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg) {
        Log$class.debug((Log)this, t, msg);
    }

    @Override
    public void debug(Throwable t, Function0<String> msg, Object param1) {
        Log$class.debug((Log)this, t, msg, param1);
    }

    @Override
    public void debug(Function0<String> msg, Object param1, Object param2) {
        Log$class.debug((Log)this, msg, param1, param2);
    }

    @Override
    public void debugf(Function0<String> msg, Seq<Object> params) {
        Log$class.debugf(this, msg, params);
    }

    @Override
    public void trace(Function0<String> msg) {
        Log$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Object param1) {
        Log$class.trace(this, msg, param1);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2) {
        Log$class.trace(this, msg, param1, param2);
    }

    @Override
    public void trace(Function0<String> msg, Object param1, Object param2, Object param3) {
        Log$class.trace(this, msg, param1, param2, param3);
    }

    @Override
    public void tracef(Function0<String> msg, Seq<Object> params) {
        Log$class.tracef(this, msg, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Log$class.isTraceEnabled(this);
    }

    @Override
    public void logStartWithArgs(String args) {
        Log$class.logStartWithArgs(this, args);
    }

    @Override
    public void logPostingShutdownRequest() {
        Log$class.logPostingShutdownRequest(this);
    }

    @Override
    public void logExceptionReported(Throwable t) {
        Log$class.logExceptionReported(this, t);
    }

    @Override
    public void logServerDidNotUnbind() {
        Log$class.logServerDidNotUnbind(this);
    }

    @Override
    public void logChannelStillBound(Channel ch, SocketAddress address) {
        Log$class.logChannelStillBound(this, ch, address);
    }

    @Override
    public void logServerDidNotClose() {
        Log$class.logServerDidNotClose(this);
    }

    @Override
    public void logChannelStillConnected(Channel ch, SocketAddress address) {
        Log$class.logChannelStillConnected(this, ch, address);
    }

    @Override
    public void logSettingMasterThreadsNotSupported() {
        Log$class.logSettingMasterThreadsNotSupported(this);
    }

    @Override
    public void logErrorBeforeReadingRequest(Throwable t) {
        Log$class.logErrorBeforeReadingRequest(this, t);
    }

    @Override
    public void logNoMembersInHashTopology(ConsistentHash ch, String topology) {
        Log$class.logNoMembersInHashTopology(this, ch, topology);
    }

    @Override
    public void logNoMembersInTopology() {
        Log$class.logNoMembersInTopology(this);
    }

    @Override
    public void logServerEndpointTopologyEmpty(String clusterMembers) {
        Log$class.logServerEndpointTopologyEmpty(this, clusterMembers);
    }

    private DefaultChannelGroup serverChannels() {
        return this.serverChannels;
    }

    public DefaultChannelGroup acceptedChannels() {
        return this.acceptedChannels;
    }

    private NioEventLoopGroup masterGroup() {
        return this.masterGroup;
    }

    private NioEventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    private AtomicLong totalBytesWritten() {
        return this.totalBytesWritten;
    }

    private AtomicLong totalBytesRead() {
        return this.totalBytesRead;
    }

    private boolean isGlobalStatsEnabled() {
        return this.isGlobalStatsEnabled;
    }

    @Override
    public void start() {
        if (this.isLog4jAvailable()) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)this.masterGroup(), (EventLoopGroup)this.workerGroup());
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler(this.handler);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(this.configuration.tcpNoDelay()));
        Object object = this.configuration.sendBufSize() > 0 ? bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(this.configuration.sendBufSize())) : BoxedUnit.UNIT;
        Object object2 = this.configuration.recvBufSize() > 0 ? bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(this.configuration.recvBufSize())) : BoxedUnit.UNIT;
        Channel ch = bootstrap.bind((SocketAddress)this.address).sync().channel();
        this.serverChannels().add(ch);
    }

    private boolean isLog4jAvailable() {
        boolean bl;
        try {
            Util.loadClassStrict((String)"org.apache.log4j.Logger", (ClassLoader)Thread.currentThread().getContextClassLoader());
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void stop() {
        ChannelGroupFuture future = this.serverChannels().close().awaitUninterruptibly();
        if (!future.isSuccess()) {
            this.logServerDidNotUnbind();
            JavaConversions$.MODULE$.asScalaIterator(future.group().iterator()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final void apply(Channel ch) {
                    if (ch.isActive()) {
                        this.$outer.logChannelStillBound(ch, ch.remoteAddress());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.serverChannels().close().awaitUninterruptibly();
        future = this.acceptedChannels().close().awaitUninterruptibly();
        if (!future.isSuccess()) {
            this.logServerDidNotClose();
            JavaConversions$.MODULE$.asScalaIterator(future.group().iterator()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final void apply(Channel ch) {
                    if (ch.isActive()) {
                        this.$outer.logChannelStillConnected(ch, ch.remoteAddress());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.isDebugEnabled()) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Channel group completely closed, release external resources";
                }
            });
        }
        this.masterGroup().shutdownGracefully();
        this.workerGroup().shutdownGracefully();
    }

    @Override
    public String getTotalBytesWritten() {
        return this.totalBytesWritten().toString();
    }

    @Override
    public String getTotalBytesRead() {
        return this.totalBytesRead().toString();
    }

    @Override
    public String getHostName() {
        return this.address.getHostName();
    }

    @Override
    public String getPort() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.address.getPort())).toString();
    }

    @Override
    public String getNumberWorkerThreads() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.configuration.workerThreads())).toString();
    }

    @Override
    public String getIdleTimeout() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.configuration.idleTimeout())).toString();
    }

    @Override
    public String getTcpNoDelay() {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)this.configuration.tcpNoDelay())).toString();
    }

    @Override
    public String getSendBufferSize() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.configuration.sendBufSize())).toString();
    }

    @Override
    public String getReceiveBufferSize() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.configuration.recvBufSize())).toString();
    }

    @Override
    public Integer getNumberOfLocalConnections() {
        return this.acceptedChannels().size();
    }

    @Override
    public Integer getNumberOfGlobalConnections() {
        return this.needDistributedCalculation() ? this.calculateGlobalConnections() : this.getNumberOfLocalConnections();
    }

    public void updateTotalBytesWritten(int bytes) {
        if (this.isGlobalStatsEnabled()) {
            this.incrementTotalBytesWritten(this.totalBytesWritten(), bytes);
        }
    }

    private void incrementTotalBytesWritten(AtomicLong base, int bytes) {
        if (this.isGlobalStatsEnabled()) {
            base.addAndGet(bytes);
        }
    }

    public void updateTotalBytesRead(int bytes) {
        if (this.isGlobalStatsEnabled()) {
            this.incrementTotalBytesRead(this.totalBytesRead(), bytes);
        }
    }

    private void incrementTotalBytesRead(AtomicLong base, int bytes) {
        if (this.isGlobalStatsEnabled()) {
            base.addAndGet(bytes);
        }
    }

    private boolean needDistributedCalculation() {
        org.infinispan.remoting.transport.Transport transport = this.cacheManager.getTransport();
        return transport != null && transport.getMembers().size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer calculateGlobalConnections() {
        Integer n;
        Cache cache = this.cacheManager.getCache();
        DefaultExecutorService exec = new DefaultExecutorService(cache);
        try {
            Iterator results = exec.submitEverywhere((Callable)((Object)new ConnectionAdderTask(this.threadNamePrefix))).iterator();
            n = (Integer)JavaConversions$.MODULE$.asScalaIterator(results).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(Future<Integer> x$1) {
                    return x$1.get(30L, TimeUnit.SECONDS);
                }
            }).reduceLeft((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Integer apply(Integer x$2, Integer x$3) {
                    return Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(x$2) + Predef$.MODULE$.Integer2int(x$3));
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown();
            throw throwable;
        }
        exec.shutdown();
        return n;
    }

    public NettyTransport(ProtocolServer server, ChannelInitializer<Channel> handler, InetSocketAddress address, ProtocolServerConfiguration configuration, String threadNamePrefix, EmbeddedCacheManager cacheManager) {
        this.handler = handler;
        this.address = address;
        this.configuration = configuration;
        this.threadNamePrefix = threadNamePrefix;
        this.cacheManager = cacheManager;
        Log$class.$init$(this);
        this.serverChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Channels").toString(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.acceptedChannels = new DefaultChannelGroup(new StringBuilder().append((Object)threadNamePrefix).append((Object)"-Accepted").toString(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.masterGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory(new StringBuilder().append((Object)threadNamePrefix).append((Object)"ServerMaster").toString()));
        this.workerGroup = new NioEventLoopGroup(configuration.workerThreads(), (ThreadFactory)new DefaultThreadFactory(new StringBuilder().append((Object)threadNamePrefix).append((Object)"ServerWorker").toString()));
        this.totalBytesWritten = new AtomicLong();
        this.totalBytesRead = new AtomicLong();
        this.isGlobalStatsEnabled = cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled();
    }
}

