/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.NamingException;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NamingStoreService
implements Service<ServiceBasedNamingStore> {
    private final boolean readOnly;
    private volatile ServiceBasedNamingStore store;

    public NamingStoreService() {
        this(false);
    }

    public NamingStoreService(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void start(StartContext context) throws StartException {
        if (this.store == null) {
            ServiceContainer serviceRegistry = context.getController().getServiceContainer();
            ServiceName serviceNameBase = context.getController().getName();
            ServiceTarget serviceTarget = context.getChildTarget();
            this.store = this.readOnly ? new ServiceBasedNamingStore((ServiceRegistry)serviceRegistry, serviceNameBase) : new WritableServiceBasedNamingStore((ServiceRegistry)serviceRegistry, serviceNameBase, serviceTarget);
        }
    }

    public void stop(StopContext context) {
        if (this.store != null) {
            try {
                this.store.close();
                this.store = null;
            }
            catch (NamingException e) {
                throw NamingMessages.MESSAGES.failedToDestroyRootContext(e);
            }
        }
    }

    public ServiceBasedNamingStore getValue() throws IllegalStateException {
        return this.store;
    }
}

