/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.ConfirmCompletedParticipant;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.impl.BeanManagerUtil;
import org.jboss.narayana.compensations.impl.CompensationContext;
import org.jboss.narayana.txframework.impl.TXDataMapImpl;

public class Participant
implements BusinessAgreementWithParticipantCompletionParticipant,
ConfirmCompletedParticipant {
    private Class<? extends CompensationHandler> compensationHandler;
    private Class<? extends ConfirmationHandler> confirmationHandler;
    private Class<? extends TransactionLoggedHandler> transactionLoggedHandler;
    private BeanManager beanManager;
    private ClassLoader applicationClassloader;
    private TxContext currentTX;
    private Map txDataMapState;

    public Participant(Class<? extends CompensationHandler> compensationHandlerClass, Class<? extends ConfirmationHandler> confirmationHandlerClass, Class<? extends TransactionLoggedHandler> transactionLoggedHandlerClass, TxContext currentTX) {
        this.compensationHandler = compensationHandlerClass;
        this.confirmationHandler = confirmationHandlerClass;
        this.transactionLoggedHandler = transactionLoggedHandlerClass;
        this.currentTX = currentTX;
        this.beanManager = BeanManagerUtil.getBeanManager();
        this.txDataMapState = TXDataMapImpl.getState();
        this.applicationClassloader = Thread.currentThread().getContextClassLoader();
    }

    private <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return BeanManagerUtil.createBeanInstance(clazz, this.beanManager);
    }

    public void confirmCompleted(boolean confirmed) {
        if (this.transactionLoggedHandler != null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationClassloader);
            TXDataMapImpl.resume(this.txDataMapState);
            TransactionLoggedHandler handler = this.instantiate(this.transactionLoggedHandler);
            handler.transactionLogged(confirmed);
            TXDataMapImpl.suspend();
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public void close() throws WrongStateException, SystemException {
        if (this.confirmationHandler != null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationClassloader);
            CompensationContext.setTxContextToExtend(this.currentTX);
            TXDataMapImpl.resume(this.txDataMapState);
            ConfirmationHandler handler = this.instantiate(this.confirmationHandler);
            handler.confirm();
            TXDataMapImpl.suspend();
            CompensationContext.close(this.currentTX);
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public void cancel() throws FaultedException, WrongStateException, SystemException {
    }

    public void compensate() throws FaultedException, WrongStateException, SystemException {
        try {
            if (this.compensationHandler != null) {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.applicationClassloader);
                CompensationContext.setTxContextToExtend(this.currentTX);
                TXDataMapImpl.resume(this.txDataMapState);
                CompensationHandler handler = this.instantiate(this.compensationHandler);
                handler.compensate();
                TXDataMapImpl.suspend();
                CompensationContext.close(this.currentTX);
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String status() throws SystemException {
        return null;
    }

    public void unknown() throws SystemException {
    }

    public void error() throws SystemException {
    }
}

