/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import java.util.Deque;
import java.util.Locale;

public class PathParameterSessionConfig
implements SessionConfig {
    private final String name;

    public PathParameterSessionConfig(String name) {
        this.name = name;
    }

    public PathParameterSessionConfig() {
        this("JSESSIONID".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        exchange.getPathParameters().remove(this.name);
        exchange.addPathParam(this.name, sessionId);
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        exchange.getPathParameters().remove(this.name);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Deque<String> stringDeque = exchange.getPathParameters().get(this.name);
        if (stringDeque == null) {
            return null;
        }
        return stringDeque.getFirst();
    }

    @Override
    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.findSessionId(exchange) != null ? SessionConfig.SessionCookieSource.URL : SessionConfig.SessionCookieSource.NONE;
    }

    @Override
    public String rewriteUrl(String url, String sessionId) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(';');
            sb.append(this.name.toLowerCase(Locale.ENGLISH));
            sb.append('=');
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }
}

