/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import org.hornetq.api.core.SimpleString;

public class Response {
    private final boolean accepted;
    private final SimpleString clusterName;
    private final SimpleString alternativeClusterName;
    private final SimpleString groupId;

    public Response(SimpleString groupId, SimpleString clusterName) {
        this(groupId, clusterName, null);
    }

    public Response(SimpleString groupId, SimpleString clusterName, SimpleString alternativeClusterName) {
        this.groupId = groupId;
        this.accepted = alternativeClusterName == null;
        this.clusterName = clusterName;
        this.alternativeClusterName = alternativeClusterName;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public SimpleString getAlternativeClusterName() {
        return this.alternativeClusterName;
    }

    public SimpleString getChosenClusterName() {
        return this.alternativeClusterName != null ? this.alternativeClusterName : this.clusterName;
    }

    public String toString() {
        return "accepted = " + this.accepted + " groupid = " + this.groupId + " clusterName = " + this.clusterName + " alternativeClusterName = " + this.alternativeClusterName;
    }

    public SimpleString getGroupId() {
        return this.groupId;
    }
}

