/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class RACKSPACE_PING
extends FILE_PING {
    protected static final Log log = LogFactory.getLog(RACKSPACE_PING.class);
    private static final String UKService = "https://lon.auth.api.rackspacecloud.com/v1.0";
    private static final String USService = "https://auth.api.rackspacecloud.com/v1.0";
    protected RackspaceClient rackspaceClient = null;
    @Property(description="Rackspace username")
    protected String username = null;
    @Property(description="Rackspace API access key", exposeAsManagedAttribute=false)
    protected String apiKey = null;
    @Property(description="Rackspace region, either UK or US")
    protected String region = null;
    @Property(description="Name of the root container")
    protected String container = "jgroups";

    @Override
    public void init() throws Exception {
        if (this.username == null) {
            throw new IllegalArgumentException("Rackspace 'username' must not be null");
        }
        if (this.apiKey == null) {
            throw new IllegalArgumentException("Rackspace 'apiKey' must not be null");
        }
        if (this.region == null || !this.region.equals("UK") && !this.region.equals("US")) {
            throw new IllegalArgumentException("Invalid 'region', must be UK or US");
        }
        URL authURL = new URL(this.region.equals("UK") ? UKService : USService);
        this.rackspaceClient = new RackspaceClient(authURL, this.username, this.apiKey);
        super.init();
    }

    @Override
    protected void createRootDir() {
        this.rackspaceClient.authenticate();
        this.rackspaceClient.createContainer(this.container);
    }

    @Override
    protected void readAll(List<Address> members, String clustername, Responses responses) {
        try {
            List<String> objects = this.rackspaceClient.listObjects(this.container);
            for (String object : objects) {
                List<PingData> list = null;
                byte[] bytes = this.rackspaceClient.readObject(this.container, object);
                list = this.read(new ByteArrayInputStream(bytes));
                if (list == null) {
                    log.warn("failed reading " + object);
                    continue;
                }
                for (PingData data : list) {
                    if (members == null || members.contains(data.getAddress())) {
                        responses.addResponse(data, data.isCoord());
                    }
                    if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                    this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                }
            }
        }
        catch (Exception e) {
            log.error("Error unmarshalling object", e);
        }
    }

    @Override
    protected void write(List<PingData> list, String clustername) {
        try {
            String filename = clustername + "/" + RACKSPACE_PING.addressToFilename(this.local_addr);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.write(list, out);
            byte[] data = out.toByteArray();
            this.rackspaceClient.createObject(this.container, filename, data);
        }
        catch (Exception e) {
            log.error("Error marshalling object", e);
        }
    }

    @Override
    protected void remove(String clustername, Address addr) {
        String fileName = clustername + "/" + RACKSPACE_PING.addressToFilename(addr);
        this.rackspaceClient.deleteObject(this.container, fileName);
    }

    static class RackspaceClient {
        private static final String ACCEPT_HEADER = "Accept";
        private static final String AUTH_HEADER = "X-Auth-User";
        private static final String AUTH_KEY_HEADER = "X-Auth-Key";
        private static final String STORAGE_TOKEN_HEADER = "X-Storage-Token";
        private static final String STORAGE_URL_HEADER = "X-Storage-Url";
        private static final String CONTENT_LENGTH_HEADER = "Content-Length";
        private final URL apiEndpoint;
        private final String username;
        private final String apiKey;
        private volatile Credentials credentials = null;

        public RackspaceClient(URL apiEndpoint, String username, String apiKey) {
            this.apiEndpoint = apiEndpoint;
            this.username = username;
            this.apiKey = apiKey;
        }

        public void authenticate() {
            HttpURLConnection urlConnection = new ConnBuilder(this.apiEndpoint).addHeader(AUTH_HEADER, this.username).addHeader(AUTH_KEY_HEADER, this.apiKey).getConnection();
            Response response = this.doAuthOperation(urlConnection);
            if (!response.isSuccessCode()) {
                throw new IllegalStateException("Error authenticating to the service. Please check your credentials. Code = " + response.code);
            }
            this.credentials = new Credentials(response.getHeader(STORAGE_TOKEN_HEADER), response.getHeader(STORAGE_URL_HEADER));
            log.trace("Authentication successful");
        }

        public void deleteObject(String containerName, String objectName) {
            HttpURLConnection urlConnection = new ConnBuilder(this.credentials, containerName, objectName).method("DELETE").getConnection();
            Response response = this.doVoidOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.deleteObject(containerName, objectName);
                } else {
                    log.error("Error deleting object " + objectName + " from container " + containerName + ",code = " + response.code);
                }
            }
        }

        public void createContainer(String containerName) {
            HttpURLConnection urlConnection = new ConnBuilder(this.credentials, containerName, null).method("PUT").getConnection();
            Response response = this.doVoidOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.createContainer(containerName);
                } else {
                    log.error("Error creating container " + containerName + " ,code = " + response.code);
                }
            }
        }

        public void createObject(String containerName, String objectName, byte[] contents) {
            HttpURLConnection conn = new ConnBuilder(this.credentials, containerName, objectName).method("PUT").addHeader(CONTENT_LENGTH_HEADER, String.valueOf(contents.length)).getConnection();
            Response response = this.doSendOperation(conn, contents);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.createObject(containerName, objectName, contents);
                } else {
                    log.error("Error creating object " + objectName + " in container " + containerName + ",code = " + response.code);
                }
            }
        }

        public byte[] readObject(String containerName, String objectName) {
            HttpURLConnection urlConnection = new ConnBuilder(this.credentials, containerName, objectName).getConnection();
            Response response = this.doReadOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    return this.readObject(containerName, objectName);
                }
                log.error("Error reading object " + objectName + " from container " + containerName + ", code = " + response.code);
            }
            return response.payload;
        }

        public List<String> listObjects(String containerName) {
            HttpURLConnection urlConnection = new ConnBuilder(this.credentials, containerName, null).getConnection();
            Response response = this.doReadOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    return this.listObjects(containerName);
                }
                log.error("Error listing container " + containerName + ", code = " + response.code);
            }
            return response.payloadAsLines();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response doOperation(HttpURLConnection urlConnection, byte[] inputData, boolean hasOutput) {
            Response response = null;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            byte[] payload = null;
            try {
                if (inputData != null) {
                    urlConnection.setDoOutput(true);
                    outputStream = urlConnection.getOutputStream();
                    outputStream.write(inputData);
                }
                if (hasOutput) {
                    inputStream = urlConnection.getInputStream();
                    payload = Util.readFileContents(urlConnection.getInputStream());
                }
                response = new Response(urlConnection.getHeaderFields(), urlConnection.getResponseCode(), payload);
            }
            catch (IOException e) {
                try {
                    log.error("Error calling service", e);
                }
                catch (Throwable throwable) {
                    Util.close(inputStream);
                    Util.close(outputStream);
                    throw throwable;
                }
                Util.close((Closeable)inputStream);
                Util.close((Closeable)outputStream);
            }
            Util.close((Closeable)inputStream);
            Util.close((Closeable)outputStream);
            return response;
        }

        private Response doAuthOperation(HttpURLConnection urlConnection) {
            return this.doOperation(urlConnection, null, false);
        }

        private Response doVoidOperation(HttpURLConnection urlConnection) {
            return this.doOperation(urlConnection, null, false);
        }

        private Response doSendOperation(HttpURLConnection urlConnection, byte[] content) {
            return this.doOperation(urlConnection, content, false);
        }

        private Response doReadOperation(HttpURLConnection urlConnection) {
            return this.doOperation(urlConnection, null, true);
        }

        private class Response {
            private final Map<String, List<String>> headers;
            private final int code;
            private final byte[] payload;

            Response(Map<String, List<String>> headers, int code, byte[] payload) {
                this.headers = headers;
                this.code = code;
                this.payload = payload;
            }

            private String getHeader(String name) {
                return this.headers.get(name).get(0);
            }

            public boolean isSuccessCode() {
                return this.code >= 200 && this.code < 300;
            }

            public boolean isAuthDenied() {
                return this.code == 401;
            }

            public List<String> payloadAsLines() {
                ArrayList<String> lines = new ArrayList<String>();
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.payload)));
                    while ((line = in.readLine()) != null) {
                        lines.add(line);
                    }
                    in.close();
                }
                catch (IOException e) {
                    log.error("Error reading objects", e);
                }
                return lines;
            }
        }

        private class Credentials {
            private final String authToken;
            private final String storageURL;

            public Credentials(String authToken, String storageURL) {
                this.authToken = authToken;
                this.storageURL = storageURL;
            }
        }

        private class ConnBuilder {
            private HttpURLConnection con;

            public ConnBuilder(URL url) {
                try {
                    this.con = (HttpURLConnection)url.openConnection();
                }
                catch (IOException e) {
                    log.error("Error building URL", e);
                }
            }

            public ConnBuilder(Credentials credentials, String container, String object) {
                try {
                    String url = credentials.storageURL + "/" + container;
                    if (object != null) {
                        url = url + "/" + object;
                    }
                    this.con = (HttpURLConnection)new URL(url).openConnection();
                    this.con.addRequestProperty(RackspaceClient.STORAGE_TOKEN_HEADER, credentials.authToken);
                    this.con.addRequestProperty(RackspaceClient.ACCEPT_HEADER, "*/*");
                }
                catch (IOException e) {
                    log.error("Error creating connection", e);
                }
            }

            public ConnBuilder method(String method) {
                try {
                    this.con.setRequestMethod(method);
                }
                catch (ProtocolException e) {
                    log.error("Protocol error", e);
                }
                return this;
            }

            public ConnBuilder addHeader(String key, String value) {
                this.con.setRequestProperty(key, value);
                return this;
            }

            public HttpURLConnection getConnection() {
                return this.con;
            }
        }
    }
}

