/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.operator;

import java.io.File;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.operator.ControlOperatorParser;
import org.jboss.aesh.util.FileLister;
import org.jboss.aesh.util.Parser;

public class RedirectionCompletion
implements Completion {
    @Override
    public void complete(CompleteOperation completeOperation) {
        if (ControlOperatorParser.doStringContainRedirectionNoPipeline(completeOperation.getBuffer())) {
            int redirectPos = ControlOperatorParser.findLastRedirectionPositionBeforeCursor(completeOperation.getBuffer(), completeOperation.getCursor());
            String word = Parser.findWordClosestToCursor(completeOperation.getBuffer().substring(redirectPos, completeOperation.getCursor()), completeOperation.getCursor() - redirectPos);
            completeOperation.setOffset(completeOperation.getCursor());
            new FileLister(word, new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
            if (completeOperation.getCompletionCandidates().size() > 1) {
                completeOperation.removeEscapedSpacesFromCompletionCandidates();
            }
        }
    }
}

