/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.near.NearCacheService;

public class NearRemoteCache<K, V>
extends RemoteCacheImpl<K, V> {
    private final NearCacheService<K, V> nearcache;

    public NearRemoteCache(RemoteCacheManager rcm, String name, NearCacheService<K, V> nearcache) {
        super(rcm, name);
        this.nearcache = nearcache;
    }

    @Override
    public V get(Object key) {
        VersionedValue<V> versioned = this.getVersioned(key);
        return versioned != null ? (V)versioned.getValue() : null;
    }

    @Override
    public VersionedValue<V> getVersioned(K key) {
        VersionedValue<V> nearValue = this.nearcache.get(key);
        if (nearValue == null) {
            VersionedValue remoteValue = super.getVersioned(key);
            if (remoteValue != null) {
                this.nearcache.putIfAbsent(key, remoteValue);
            }
            return remoteValue;
        }
        return nearValue;
    }

    @Override
    public void start() {
        this.nearcache.start(this);
    }

    @Override
    public void stop() {
        this.nearcache.stop(this);
    }
}

