/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.PromptRealmState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;

public class ValidateRealmState
implements State {
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public ValidateRealmState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        String enteredRealm = this.stateValues.getRealm();
        if (enteredRealm.length() == 0) {
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.realmMustBeSpecified(), new PromptRealmState(this.theConsole, this.stateValues));
        }
        if (this.stateValues.getFileMode() != AddUser.FileMode.UNDEFINED) {
            String expectedRealm;
            String string = expectedRealm = this.stateValues.getFileMode() == AddUser.FileMode.MANAGEMENT ? "ManagementRealm" : "ApplicationRealm";
            if (!expectedRealm.equals(enteredRealm)) {
                String message = DomainManagementMessages.MESSAGES.alternativeRealm(expectedRealm);
                String prompt = DomainManagementMessages.MESSAGES.realmConfirmation(enteredRealm) + " " + DomainManagementMessages.MESSAGES.yes() + "/" + DomainManagementMessages.MESSAGES.no() + "?";
                return new ConfirmationChoice(this.theConsole, message, prompt, (State)new PromptNewUserState(this.theConsole, this.stateValues), (State)new PromptRealmState(this.theConsole, this.stateValues));
            }
        }
        return new PromptNewUserState(this.theConsole, this.stateValues);
    }
}

