/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EvictionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<EvictionConfiguration> {
    private static final Log log = LogFactory.getLog(EvictionConfigurationBuilder.class);
    private final AttributeSet attributes = EvictionConfiguration.attributeDefinitionSet();
    public static final long EVICTION_MAX_SIZE = 0xFFFFFFFFFFFFFFL;

    EvictionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public EvictionConfigurationBuilder strategy(EvictionStrategy evictionStrategy) {
        this.attributes.attribute(EvictionConfiguration.STRATEGY).set((Object)evictionStrategy);
        return this;
    }

    EvictionStrategy strategy() {
        return (EvictionStrategy)((Object)this.attributes.attribute(EvictionConfiguration.STRATEGY).get());
    }

    public EvictionConfigurationBuilder threadPolicy(EvictionThreadPolicy policy) {
        this.attributes.attribute(EvictionConfiguration.THREAD_POLICY).set((Object)policy);
        return this;
    }

    public EvictionConfigurationBuilder maxEntries(long maxEntries) {
        this.attributes.attribute(EvictionConfiguration.MAX_ENTRIES).set((Object)maxEntries);
        return this;
    }

    public void validate() {
        EvictionStrategy strategy = (EvictionStrategy)((Object)this.attributes.attribute(EvictionConfiguration.STRATEGY).get());
        Long maxEntries = (Long)this.attributes.attribute(EvictionConfiguration.MAX_ENTRIES).get();
        if (!strategy.isEnabled() && this.getBuilder().persistence().passivation()) {
            log.passivationWithoutEviction();
        }
        if (strategy == EvictionStrategy.FIFO) {
            log.warnFifoStrategyIsDeprecated();
        }
        if (strategy.isEnabled() && maxEntries <= 0L) {
            throw new CacheConfigurationException("Eviction maxEntries value cannot be less than or equal to zero if eviction is enabled");
        }
        if (maxEntries > 0L && !strategy.isEnabled()) {
            this.strategy(EvictionStrategy.LIRS);
            log.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overriden to %s", maxEntries, (Object)strategy);
        }
        if (maxEntries > 0xFFFFFFFFFFFFFFL) {
            throw log.evictionSizeTooLarge(maxEntries);
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public EvictionConfiguration create() {
        return new EvictionConfiguration(this.attributes.protect());
    }

    public EvictionConfigurationBuilder read(EvictionConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.attributes;
    }
}

