/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.PeekableMap;
import org.infinispan.commons.util.concurrent.ParallelIterableMap;
import org.infinispan.commons.util.concurrent.jdk8backported.BoundedEquivalentConcurrentHashMapV8;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.CoreImmutables;
import org.infinispan.util.TimeService;

@ThreadSafe
public class DefaultDataContainer<K, V>
implements DataContainer<K, V> {
    private static final Log log = LogFactory.getLog(DefaultDataContainer.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentMap<K, InternalCacheEntry<K, V>> entries;
    private final ExtendedMap<K, V> extendedMap;
    protected InternalEntryFactory entryFactory;
    private EvictionManager evictionManager;
    private PassivationManager passivator;
    private ActivationManager activator;
    private PersistenceManager pm;
    private TimeService timeService;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = CollectionFactory.makeConcurrentParallelMap((int)128, (int)concurrencyLevel);
        this.extendedMap = new EquivalentConcurrentExtendedMap();
    }

    public DefaultDataContainer(int concurrencyLevel, Equivalence<? super K> keyEq) {
        this.entries = CollectionFactory.makeConcurrentParallelMap((int)128, (int)concurrencyLevel, keyEq, (Equivalence)AnyEquivalence.getInstance());
        this.extendedMap = new EquivalentConcurrentExtendedMap();
    }

    protected DefaultDataContainer(int concurrencyLevel, long maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy, Equivalence<? super K> keyEquivalence) {
        DefaultEvictionListener evictionListener;
        switch (policy) {
            case PIGGYBACK: 
            case DEFAULT: {
                evictionListener = new DefaultEvictionListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction thread policy " + (Object)((Object)strategy));
            }
        }
        switch (strategy) {
            case FIFO: 
            case UNORDERED: 
            case LRU: {
                BoundedEquivalentConcurrentHashMapV8.Eviction eviction = BoundedEquivalentConcurrentHashMapV8.Eviction.LRU;
                break;
            }
            case LIRS: {
                BoundedEquivalentConcurrentHashMapV8.Eviction eviction = BoundedEquivalentConcurrentHashMapV8.Eviction.LIRS;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction strategy " + (Object)((Object)strategy));
            }
        }
        this.entries = new BoundedEquivalentConcurrentHashMapV8(maxEntries, BoundedEquivalentConcurrentHashMapV8.Eviction.LRU, (BoundedEquivalentConcurrentHashMapV8.EvictionListener)evictionListener, keyEquivalence, (Equivalence)AnyEquivalence.getInstance());
        this.extendedMap = new BoundedEquivalentConcurrentExtendedMap();
    }

    @Inject
    public void initialize(EvictionManager evictionManager, PassivationManager passivator, InternalEntryFactory entryFactory, ActivationManager activator, PersistenceManager clm, TimeService timeService) {
        this.evictionManager = evictionManager;
        this.passivator = passivator;
        this.entryFactory = entryFactory;
        this.activator = activator;
        this.pm = clm;
        this.timeService = timeService;
    }

    public static <K, V> DataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy, Equivalence<? super K> keyEquivalence) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, strategy, policy, keyEquivalence);
    }

    public static <K, V> DataContainer<K, V> unBoundedDataContainer(int concurrencyLevel, Equivalence<? super K> keyEquivalence) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, keyEquivalence);
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object key) {
        if (this.entries instanceof PeekableMap) {
            return (InternalCacheEntry)((PeekableMap)this.entries).peek(key);
        }
        return (InternalCacheEntry)this.entries.get(key);
    }

    @Override
    public InternalCacheEntry<K, V> get(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null && e.canExpire()) {
            long currentTimeMillis = this.timeService.wallClockTime();
            if (e.isExpired(currentTimeMillis)) {
                this.entries.remove(k, e);
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public void put(K k, V v, Metadata metadata) {
        boolean l1Entry = false;
        if (metadata instanceof L1Metadata) {
            metadata = ((L1Metadata)metadata).metadata();
            l1Entry = true;
        }
        InternalCacheEntry<K, V> e = (InternalCacheEntry<K, V>)this.entries.get(k);
        if (trace) {
            log.tracef("Creating new ICE for writing. Existing=%s, metadata=%s, new value=%s", (Object)e, (Object)metadata, v);
        }
        e = l1Entry ? this.entryFactory.createL1(k, v, metadata) : (e != null ? this.entryFactory.update(e, v, metadata) : this.entryFactory.create(k, v, metadata));
        if (trace) {
            log.tracef("Store %s in container", e);
        }
        this.extendedMap.putAndActivate(e);
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry<K, V> ice = this.peek(k);
        if (ice != null && ice.canExpire() && ice.isExpired(this.timeService.wallClockTime())) {
            this.entries.remove(k);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry<K, V> remove(Object k) {
        InternalCacheEntry<K, V> e = this.extendedMap.removeAndActivate(k);
        return e == null || e.canExpire() && e.isExpired(this.timeService.wallClockTime()) ? null : e;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        log.tracef("Clearing data container", new Object[0]);
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        long currentTimeMillis = this.timeService.wallClockTime();
        Iterator purgeCandidates = this.entries.values().iterator();
        while (purgeCandidates.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)purgeCandidates.next();
            if (!e.isExpired(currentTimeMillis)) continue;
            purgeCandidates.remove();
        }
    }

    @Override
    public void evict(K key) {
        this.extendedMap.evict(key);
    }

    @Override
    public InternalCacheEntry<K, V> compute(K key, DataContainer.ComputeAction<K, V> action) {
        return this.extendedMap.compute(key, action);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new EntryIterator(this.entries.values().iterator());
    }

    @Override
    public void executeTask(final KeyFilter<? super K> filter, final ParallelIterableMap.KeyValueAction<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        ParallelIterableMap map = (ParallelIterableMap)this.entries;
        map.forEach(32L, new ParallelIterableMap.KeyValueAction<K, InternalCacheEntry<K, V>>(){

            public void apply(K key, InternalCacheEntry<K, V> value) {
                if (filter.accept(key)) {
                    action.apply(key, value);
                }
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void executeTask(final KeyValueFilter<? super K, ? super V> filter, final ParallelIterableMap.KeyValueAction<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        ParallelIterableMap map = (ParallelIterableMap)this.entries;
        map.forEach(32L, new ParallelIterableMap.KeyValueAction<K, InternalCacheEntry<K, V>>(){

            public void apply(K key, InternalCacheEntry<K, V> value) {
                if (filter.accept(key, value.getValue(), value.getMetadata())) {
                    action.apply(key, value);
                }
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private class BoundedEquivalentConcurrentExtendedMap
    implements ExtendedMap<K, V> {
        private BoundedEquivalentConcurrentExtendedMap() {
        }

        @Override
        public void evict(K key) {
            ((BoundedEquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).computeIfPresent(key, new BoundedEquivalentConcurrentHashMapV8.BiFun<K, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(K o, InternalCacheEntry<K, V> entry) {
                    DefaultDataContainer.this.passivator.passivate(entry);
                    return null;
                }
            });
        }

        @Override
        public InternalCacheEntry<K, V> compute(K key, final DataContainer.ComputeAction<K, V> action) {
            return (InternalCacheEntry)((BoundedEquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new BoundedEquivalentConcurrentHashMapV8.BiFun<K, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(K key, InternalCacheEntry<K, V> oldEntry) {
                    InternalCacheEntry newEntry = action.compute(key, oldEntry, DefaultDataContainer.this.entryFactory);
                    if (newEntry == oldEntry) {
                        return oldEntry;
                    }
                    if (newEntry == null) {
                        DefaultDataContainer.this.activator.onRemove(key, false);
                        return null;
                    }
                    DefaultDataContainer.this.activator.onUpdate(key, oldEntry == null);
                    if (trace) {
                        log.tracef("Store %s in container", newEntry);
                    }
                    return newEntry;
                }
            });
        }

        @Override
        public void putAndActivate(final InternalCacheEntry<K, V> newEntry) {
            ((BoundedEquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(newEntry.getKey(), new BoundedEquivalentConcurrentHashMapV8.BiFun<K, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(K key, InternalCacheEntry<K, V> entry) {
                    DefaultDataContainer.this.activator.onUpdate(key, entry == null);
                    return newEntry;
                }
            });
        }

        @Override
        public InternalCacheEntry<K, V> removeAndActivate(Object key) {
            final AtomicReference<Object> reference = new AtomicReference<Object>(null);
            ((BoundedEquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new BoundedEquivalentConcurrentHashMapV8.BiFun<Object, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(Object key, InternalCacheEntry<K, V> entry) {
                    DefaultDataContainer.this.activator.onRemove(key, entry == null);
                    reference.set(entry);
                    return null;
                }
            });
            return reference.get();
        }
    }

    private class EquivalentConcurrentExtendedMap
    implements ExtendedMap<K, V> {
        private EquivalentConcurrentExtendedMap() {
        }

        @Override
        public void evict(K key) {
            ((EquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).computeIfPresent(key, new EquivalentConcurrentHashMapV8.BiFun<K, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(K o, InternalCacheEntry<K, V> entry) {
                    DefaultDataContainer.this.passivator.passivate(entry);
                    return null;
                }
            });
        }

        @Override
        public InternalCacheEntry<K, V> compute(K key, final DataContainer.ComputeAction<K, V> action) {
            return (InternalCacheEntry)((EquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new EquivalentConcurrentHashMapV8.BiFun<K, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(K key, InternalCacheEntry<K, V> oldEntry) {
                    InternalCacheEntry newEntry = action.compute(key, oldEntry, DefaultDataContainer.this.entryFactory);
                    if (newEntry == oldEntry) {
                        return oldEntry;
                    }
                    if (newEntry == null) {
                        DefaultDataContainer.this.activator.onRemove(key, false);
                        return null;
                    }
                    DefaultDataContainer.this.activator.onUpdate(key, oldEntry == null);
                    if (trace) {
                        log.tracef("Store %s in container", newEntry);
                    }
                    return newEntry;
                }
            });
        }

        @Override
        public void putAndActivate(final InternalCacheEntry<K, V> newEntry) {
            ((EquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(newEntry.getKey(), new EquivalentConcurrentHashMapV8.BiFun<K, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(K key, InternalCacheEntry<K, V> entry) {
                    DefaultDataContainer.this.activator.onUpdate(key, entry == null);
                    return newEntry;
                }
            });
        }

        @Override
        public InternalCacheEntry<K, V> removeAndActivate(Object key) {
            final AtomicReference<Object> reference = new AtomicReference<Object>(null);
            ((EquivalentConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new EquivalentConcurrentHashMapV8.BiFun<Object, InternalCacheEntry<K, V>, InternalCacheEntry<K, V>>(){

                public InternalCacheEntry<K, V> apply(Object key, InternalCacheEntry<K, V> entry) {
                    DefaultDataContainer.this.activator.onRemove(key, entry == null);
                    reference.set(entry);
                    return null;
                }
            });
            return reference.get();
        }
    }

    private static interface ExtendedMap<K, V> {
        public void evict(K var1);

        public InternalCacheEntry<K, V> compute(K var1, DataContainer.ComputeAction<K, V> var2);

        public void putAndActivate(InternalCacheEntry<K, V> var1);

        public InternalCacheEntry<K, V> removeAndActivate(Object var1);
    }

    private static class ValueIterator<K, V>
    implements Iterator<V> {
        Iterator<InternalCacheEntry<K, V>> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = (InternalCacheEntry)DefaultDataContainer.this.entries.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry<K, V>> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }

        @Override
        public String toString() {
            return DefaultDataContainer.this.entries.toString();
        }
    }

    public static class EntryIterator<K, V>
    implements Iterator<InternalCacheEntry<K, V>> {
        private final Iterator<InternalCacheEntry<K, V>> it;

        EntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.it = it;
        }

        @Override
        public InternalCacheEntry<K, V> next() {
            return this.it.next();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutableEntryIterator<K, V>
    extends EntryIterator<K, V> {
        ImmutableEntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            super(it);
        }

        @Override
        public InternalCacheEntry<K, V> next() {
            return CoreImmutables.immutableInternalCacheEntry(super.next());
        }
    }

    private final class DefaultEvictionListener
    implements BoundedEquivalentConcurrentHashMapV8.EvictionListener<K, InternalCacheEntry<K, V>> {
        private DefaultEvictionListener() {
        }

        public void onEntryEviction(Map<K, InternalCacheEntry<K, V>> evicted) {
            DefaultDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        public void onEntryChosenForEviction(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
            DefaultDataContainer.this.passivator.passivate(entry.getValue());
        }

        public void onEntryActivated(Object key) {
            DefaultDataContainer.this.activator.onUpdate(key, true);
        }

        public void onEntryRemoved(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
            if (entry.getValue().isEvicted()) {
                this.onEntryChosenForEviction(entry);
            } else if (DefaultDataContainer.this.pm != null) {
                DefaultDataContainer.this.pm.deleteFromAllStores(entry.getKey(), PersistenceManager.AccessMode.BOTH);
            }
        }
    }
}

