/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.ClusteredActivationInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredCacheLoaderInterceptor
extends CacheLoaderInterceptor {
    private static final Log log = LogFactory.getLog(ClusteredActivationInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean transactional;
    private ClusteringDependentLogic cdl;
    private StateTransferManager stateTransferManager;
    private boolean distributed;

    @Inject
    private void injectDependencies(ClusteringDependentLogic cdl, StateTransferManager stateTransferManager) {
        this.cdl = cdl;
        this.stateTransferManager = stateTransferManager;
    }

    @Start(priority=15)
    private void startClusteredCacheLoaderInterceptor() {
        this.transactional = this.cacheConfiguration.transaction().transactionMode().isTransactional();
        this.distributed = this.cacheConfiguration.clustering().cacheMode().isDistributed();
    }

    @Override
    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        return this.transactional ? this.skipLoadForTxCommand(cmd, key, ctx) : this.skipLoadForNonTxCommand(cmd, key);
    }

    private boolean skipLoadForNonTxCommand(WriteCommand cmd, Object key) {
        if (this.cdl.localNodeIsPrimaryOwner(key) || cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            boolean skip;
            if (this.isDeltaWrite(cmd)) {
                if (trace) {
                    log.tracef("Don't skip load for DeltaWrite or conditional command %s.", cmd);
                }
                return false;
            }
            if (this.isConditional(cmd)) {
                boolean skip2 = this.hasSkipLoadFlag(cmd);
                if (trace) {
                    log.tracef("Skip load for conditional command %s? %s", cmd, skip2);
                }
                return skip2;
            }
            boolean bl = skip = this.hasSkipLoadFlag(cmd) || this.hasIgnoreReturnValueFlag(cmd);
            if (trace) {
                log.tracef("Skip load for command %s? %s", cmd, skip);
            }
            return skip;
        }
        if (trace) {
            log.tracef("Skip load for command %s. This node is not the primary owner of %s", cmd, key);
        }
        return true;
    }

    private boolean skipLoadForTxCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        boolean skip;
        if (this.isDeltaWrite(cmd)) {
            if (trace) {
                log.tracef("Don't skip load for DeltaWrite command %s.", cmd);
            }
            return false;
        }
        if (this.isConditional(cmd)) {
            boolean skip2 = this.hasSkipLoadFlag(cmd);
            if (trace) {
                log.tracef("Skip load for conditional command %s? %s", cmd, skip2);
            }
            return skip2;
        }
        boolean bl = skip = this.hasSkipLoadFlag(cmd) || this.hasIgnoreReturnValueFlag(cmd);
        if (trace) {
            log.tracef("Skip load for command %s? %s", skip);
        }
        return skip || !ctx.isOriginLocal() && !this.cdl.localNodeIsPrimaryOwner(key);
    }

    @Override
    protected boolean canLoad(Object key) {
        return this.stateTransferManager.isJoinComplete() && (!this.distributed || this.isKeyLocal(key));
    }

    private boolean isKeyLocal(Object key) {
        return this.stateTransferManager.getCacheTopology().getReadConsistentHash().isKeyLocalToNode(this.cdl.getAddress(), key);
    }
}

