/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.RemoteValueRetrievedListener;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.ClusteringInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseDistributionInterceptor
extends ClusteringInterceptor {
    protected DistributionManager dm;
    protected ClusteringDependentLogic cdl;
    protected RemoteValueRetrievedListener rvrl;
    private GroupManager groupManager;
    private static final Log log = LogFactory.getLog(BaseDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(DistributionManager distributionManager, ClusteringDependentLogic cdl, RemoteValueRetrievedListener rvrl, GroupManager groupManager) {
        this.dm = distributionManager;
        this.cdl = cdl;
        this.rvrl = rvrl;
        this.groupManager = groupManager;
    }

    @Override
    public final Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        Response response;
        String groupName = command.getGroupName();
        if (command.isGroupOwner()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(Collections.singleton(this.groupManager.getPrimaryOwner(groupName)), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true));
        if (!responseMap.isEmpty() && (response = responseMap.values().iterator().next()) instanceof SuccessfulResponse) {
            List cacheEntries = (List)((SuccessfulResponse)response).getResponseValue();
            for (CacheEntry entry : cacheEntries) {
                this.entryFactory.wrapEntryForReading(ctx, entry.getKey(), entry);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command)));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected final InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx, boolean acquireRemoteLock, FlagAffectedCommand command, boolean isWrite) throws Exception {
        GlobalTransaction gtx = ctx.isInTxScope() ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, command.getFlags(), acquireRemoteLock, gtx);
        get.setWrite(isWrite);
        RpcOptionsBuilder rpcOptionsBuilder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.WAIT_FOR_VALID_RESPONSE, DeliverOrder.NONE);
        int lastTopologyId = -1;
        InternalCacheEntry value = null;
        while (value == null) {
            ArrayList<Address> targets;
            CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
            int currentTopologyId = cacheTopology.getTopologyId();
            if (trace) {
                log.tracef("Perform remote get for key %s. topologyId=%s, currentTopologyId=%s", key, lastTopologyId, currentTopologyId);
            }
            if (lastTopologyId < currentTopologyId) {
                lastTopologyId = currentTopologyId;
                targets = new ArrayList<Address>(cacheTopology.getReadConsistentHash().locateOwners(key));
            } else if (lastTopologyId == currentTopologyId && cacheTopology.getPendingCH() != null) {
                lastTopologyId = currentTopologyId + 1;
                targets = new ArrayList<Address>(cacheTopology.getPendingCH().locateOwners(key));
                targets.removeAll(cacheTopology.getReadConsistentHash().locateOwners(key));
                if (targets.isEmpty()) {
                    if (!trace) break;
                    log.tracef("No valid values found for key '%s' (topologyId=%s).", key, currentTopologyId);
                    break;
                }
            } else {
                if (!trace) break;
                log.tracef("No valid values found for key '%s' (topologyId=%s).", key, currentTopologyId);
                break;
            }
            value = this.invokeClusterGetCommandRemotely(targets, rpcOptionsBuilder, get, key);
            if (!trace) continue;
            log.tracef("Remote get of key '%s' (topologyId=%s) returns %s", key, currentTopologyId, value);
        }
        return value;
    }

    private InternalCacheEntry invokeClusterGetCommandRemotely(List<Address> targets, RpcOptionsBuilder rpcOptionsBuilder, ClusteredGetCommand get, Object key) {
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.rpcManager.getAddress());
        RpcOptions options = rpcOptionsBuilder.responseFilter(filter).build();
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, (ReplicableCommand)get, options);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                SuccessfulResponse response;
                Object responseValue;
                if (!(r instanceof SuccessfulResponse) || (responseValue = (response = (SuccessfulResponse)r).getResponseValue()) == null) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)responseValue;
                InternalCacheEntry ice = cacheValue.toInternalCacheEntry(key);
                if (this.rvrl != null) {
                    this.rvrl.remoteValueFound(ice);
                }
                return ice;
            }
        }
        if (this.rvrl != null) {
            this.rvrl.remoteValueNotFound(key);
        }
        return null;
    }

    protected Map<Object, InternalCacheEntry> retrieveFromRemoteSources(Set<?> requestedKeys, InvocationContext ctx, Set<Flag> flags) throws Throwable {
        GlobalTransaction gtx = ctx.isInTxScope() ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        HashMap ownerKeys = new HashMap();
        for (Object key : requestedKeys) {
            Address owner = ch.locatePrimaryOwner(key);
            ArrayList requestedKeysFromNode = (ArrayList)ownerKeys.get(owner);
            if (requestedKeysFromNode == null) {
                requestedKeysFromNode = new ArrayList();
                ownerKeys.put(owner, requestedKeysFromNode);
            }
            requestedKeysFromNode.add(key);
        }
        HashMap<Address, ReplicableCommand> commands = new HashMap<Address, ReplicableCommand>();
        for (Map.Entry entry : ownerKeys.entrySet()) {
            List keys = (List)entry.getValue();
            ClusteredGetAllCommand remoteGetAll = this.cf.buildClusteredGetAllCommand(keys, flags, gtx);
            commands.put((Address)entry.getKey(), remoteGetAll);
        }
        RpcOptionsBuilder rpcOptionsBuilder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE);
        RpcOptions options = rpcOptionsBuilder.build();
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(commands, options);
        HashMap<Object, InternalCacheEntry> entries = new HashMap<Object, InternalCacheEntry>();
        for (Map.Entry<Address, Response> entry : responses.entrySet()) {
            this.updateWithValues(((ClusteredGetAllCommand)commands.get(entry.getKey())).getKeys(), entry.getValue(), entries);
        }
        return entries;
    }

    private void updateWithValues(List<?> keys, Response r, Map<Object, InternalCacheEntry> entries) {
        SuccessfulResponse response;
        List values;
        if (r instanceof SuccessfulResponse && (values = (List)(response = (SuccessfulResponse)r).getResponseValue()) != null) {
            for (int i = 0; i < keys.size(); ++i) {
                InternalCacheValue icv = (InternalCacheValue)values.get(i);
                if (icv == null) continue;
                Object key = keys.get(i);
                Object value = icv.getValue();
                if (value == null) {
                    entries.put(key, null);
                    continue;
                }
                InternalCacheEntry ice = icv.toInternalCacheEntry(key);
                entries.put(key, ice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object handleNonTxWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        Map<Address, Response> addressResponseMap;
        if (ctx.isInTxScope()) {
            throw new CacheException("Attempted execution of non-transactional write command in a transactional invocation context");
        }
        SingleKeyRecipientGenerator recipientGenerator = new SingleKeyRecipientGenerator(command.getKey());
        if (this.needValuesFromPreviousOwners(ctx, command)) {
            this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        }
        Object localResult = this.invokeNextInterceptor(ctx, command);
        if (this.isLocalModeForced(command)) {
            return localResult;
        }
        boolean isSync = this.isSynchronous(command);
        Address primaryOwner = this.cdl.getPrimaryOwner(command.getKey());
        int commandTopologyId = command.getTopologyId();
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        boolean topologyChanged = isSync && currentTopologyId != commandTopologyId && commandTopologyId != -1;
        log.tracef("Command topology id is %d, current topology id is %d, successful? %s", commandTopologyId, currentTopologyId, command.isSuccessful());
        if (topologyChanged) {
            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
        }
        ValueMatcher valueMatcher = command.getValueMatcher();
        if (!ctx.isOriginLocal()) {
            if (primaryOwner.equals(this.rpcManager.getAddress())) {
                if (!command.isSuccessful()) {
                    log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", command);
                    return localResult;
                }
                List<Address> recipients = recipientGenerator.generateRecipients();
                command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
                try {
                    this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, this.determineRpcOptionsForBackupReplication(this.rpcManager, isSync, recipients));
                }
                finally {
                    command.setValueMatcher(valueMatcher.matcherForRetry());
                }
            }
            return localResult;
        }
        if (primaryOwner.equals(this.rpcManager.getAddress())) {
            boolean isSingleOwnerAndLocal;
            if (!command.isSuccessful()) {
                log.tracef("Skipping the replication of the command as it did not succeed on primary owner (%s).", command);
                return localResult;
            }
            List<Address> recipients = recipientGenerator.generateRecipients();
            log.tracef("I'm the primary owner, sending the command to all the backups (%s) in order to be applied.", recipients);
            boolean bl = isSingleOwnerAndLocal = this.cacheConfiguration.clustering().hash().numOwners() == 1;
            if (!isSingleOwnerAndLocal) {
                command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
                try {
                    this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, this.determineRpcOptionsForBackupReplication(this.rpcManager, isSync, recipients));
                }
                finally {
                    command.setValueMatcher(valueMatcher.matcherForRetry());
                }
            }
            return localResult;
        }
        log.tracef("I'm not the primary owner, so sending the command to the primary owner(%s) in order to be forwarded", primaryOwner);
        boolean isSyncForwarding = isSync || this.isNeedReliableReturnValues(command);
        try {
            addressResponseMap = this.rpcManager.invokeRemotely(Collections.singletonList(primaryOwner), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(isSyncForwarding));
        }
        catch (RemoteException e) {
            Object ce = e;
            while (ce instanceof RemoteException) {
                ce = ((Throwable)ce).getCause();
            }
            if (ce instanceof OutdatedTopologyException) {
                if (trace) {
                    log.tracef("Changing the value matching policy from %s to %s (original value was %s)", (Object)command.getValueMatcher(), (Object)valueMatcher.matcherForRetry(), (Object)valueMatcher);
                }
                command.setValueMatcher(valueMatcher.matcherForRetry());
            }
            throw e;
        }
        catch (SuspectException e) {
            if (trace) {
                log.tracef("Primary owner suspected - Changing the value matching policy from %s to %s (original value was %s)", (Object)command.getValueMatcher(), (Object)valueMatcher.matcherForRetry(), (Object)valueMatcher);
            }
            command.setValueMatcher(valueMatcher.matcherForRetry());
            throw e;
        }
        if (!isSyncForwarding) {
            return localResult;
        }
        Object primaryResult = this.getResponseFromPrimaryOwner(primaryOwner, addressResponseMap);
        command.updateStatusFromRemoteResponse(primaryResult);
        return primaryResult;
    }

    private RpcOptions determineRpcOptionsForBackupReplication(RpcManager rpc, boolean isSync, List<Address> recipients) {
        RpcOptions options = isSync ? (recipients == null ? rpc.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS).build() : rpc.getDefaultRpcOptions(true)) : rpc.getDefaultRpcOptions(false);
        return options;
    }

    private Object getResponseFromPrimaryOwner(Address primaryOwner, Map<Address, Response> addressResponseMap) {
        Response fromPrimaryOwner = addressResponseMap.get(primaryOwner);
        if (fromPrimaryOwner == null) {
            log.tracef("Primary owner %s returned null", primaryOwner);
            return null;
        }
        if (fromPrimaryOwner.isSuccessful()) {
            return ((SuccessfulResponse)fromPrimaryOwner).getResponseValue();
        }
        if (addressResponseMap.get(primaryOwner) instanceof CacheNotFoundResponse) {
            throw new OutdatedTopologyException("Cache is no longer running on primary owner " + primaryOwner);
        }
        Exception cause = fromPrimaryOwner instanceof ExceptionResponse ? ((ExceptionResponse)fromPrimaryOwner).getException() : null;
        throw new CacheException("Got unsuccessful response from primary owner: " + fromPrimaryOwner, (Throwable)cause);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) || command.hasFlag(Flag.IGNORE_RETURN_VALUES)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        int commandTopologyId = command.getTopologyId();
        if (ctx.isOriginLocal()) {
            boolean topologyChanged;
            int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
            boolean bl = topologyChanged = currentTopologyId != commandTopologyId && commandTopologyId != -1;
            if (trace) {
                log.tracef("Command topology id is %d, current topology id is %d", commandTopologyId, currentTopologyId);
            }
            if (topologyChanged) {
                throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
            }
            ConsistentHash ch = command.getConsistentHash();
            HashSet requestedKeys = new HashSet();
            for (Object key : command.getKeys()) {
                CacheEntry entry = ctx.lookupEntry(key);
                if (entry != null) continue;
                if (!this.isValueAvailableLocally(ch, key)) {
                    requestedKeys.add(key);
                    continue;
                }
                if (trace) {
                    log.tracef("Not doing a remote get for missing key %s since entry is mapped to current node (%s). Owners are %s", Util.toStr(key), this.rpcManager.getAddress(), ch.locateOwners(key));
                }
                this.entryFactory.wrapEntryForPut(ctx, key, null, false, command, false);
            }
            boolean missingRemoteValues = false;
            if (!requestedKeys.isEmpty()) {
                if (trace) {
                    log.tracef("Fetching entries for keys %s from remote nodes", requestedKeys);
                }
                Map<Object, InternalCacheEntry> justRetrieved = this.retrieveFromRemoteSources(requestedKeys, ctx, command.getFlags());
                for (Object key : requestedKeys) {
                    if (!justRetrieved.containsKey(key)) {
                        missingRemoteValues = true;
                        continue;
                    }
                    this.entryFactory.wrapEntryForPut(ctx, key, justRetrieved.get(key), false, command, false);
                }
            }
            if (missingRemoteValues) {
                throw new OutdatedTopologyException("Remote values are missing because of a topology change");
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        boolean topologyChanged = currentTopologyId != commandTopologyId && commandTopologyId != -1;
        ConsistentHash ch = command.getConsistentHash();
        for (Object key : command.getKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry != null && !entry.isNull() || !this.isValueAvailableLocally(ch, key) || topologyChanged) continue;
            if (trace) {
                log.tracef("Not doing a remote get for missing key %s since entry is mapped to current node (%s). Owners are %s", Util.toStr(key), this.rpcManager.getAddress(), ch.locateOwners(key));
            }
            this.entryFactory.wrapEntryForPut(ctx, key, null, false, command, false);
        }
        Map values = (Map)this.invokeNextInterceptor(ctx, command);
        return values;
    }

    protected abstract boolean needValuesFromPreviousOwners(InvocationContext var1, WriteCommand var2);

    protected abstract void remoteGetBeforeWrite(InvocationContext var1, WriteCommand var2, RecipientGenerator var3) throws Throwable;

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        private final Collection<Object> keys;
        private List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = BaseDistributionInterceptor.this.cdl.getOwners(this.keys);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        private final Object key;
        private final Set<Object> keys;
        private List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = BaseDistributionInterceptor.this.cdl.getOwners(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator {
        public Collection<Object> getKeys();

        public List<Address> generateRecipients();
    }
}

