/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.security.PrivilegedAction;
import java.util.List;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;

abstract class AbstractServerGroupRolloutTask
implements Runnable {
    protected final List<ServerUpdateTask> tasks;
    protected final ServerUpdatePolicy updatePolicy;
    protected final ServerTaskExecutor executor;
    protected final Subject subject;

    public AbstractServerGroupRolloutTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, Subject subject) {
        this.tasks = tasks;
        this.updatePolicy = updatePolicy;
        this.executor = executor;
        this.subject = subject;
    }

    @Override
    public void run() {
        try {
            AccessAuditContext.doAs((Subject)this.subject, (PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AbstractServerGroupRolloutTask.this.execute();
                    return null;
                }
            });
        }
        catch (Throwable t) {
            DomainControllerLogger.ROOT_LOGGER.debugf(t, "failed to process task %s", this.tasks.iterator().next().getOperation());
        }
    }

    protected abstract void execute();

    protected void recordPreparedOperation(ServerIdentity identity, TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation> prepared) {
        ModelNode preparedResult = prepared.getPreparedResult();
        this.updatePolicy.recordServerResult(identity, preparedResult);
        this.executor.recordPreparedOperation(prepared);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{server-group=" + this.updatePolicy.getServerGroupName() + "}";
    }
}

