/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

public abstract class MarshallerObjectOutputStream
extends ObjectOutputStream
implements ByteOutput {
    private final Marshaller output;

    protected MarshallerObjectOutputStream(Marshaller output) throws IOException, SecurityException {
        this.output = output;
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.output.writeObject(obj);
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.output.writeObjectUnshared(obj);
    }

    @Override
    public void write(int val) throws IOException {
        this.output.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.output.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.output.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.output.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.output.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.output.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.output.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.output.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.output.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.output.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.output.writeDouble(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.output.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.output.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.output.writeUTF(str);
    }

    @Override
    public final void reset() throws IOException {
        throw new IOException("reset() may not be invoked on this stream");
    }

    @Override
    public final void close() throws IOException {
        throw new IllegalStateException("Stream may not be closed in this context");
    }

    @Override
    public final void useProtocolVersion(int version) throws IOException {
        throw new IllegalStateException("Protocol version may not be changed");
    }

    @Override
    protected final void annotateClass(Class<?> cl) throws IOException {
        throw new IllegalStateException("Class may not be annotated in this context");
    }

    @Override
    protected final void annotateProxyClass(Class<?> cl) throws IOException {
        throw new IllegalStateException("Class may not be annotated in this context");
    }

    @Override
    protected final Object replaceObject(Object obj) throws IOException {
        throw new IllegalStateException("Object may not be replaced in this context");
    }

    @Override
    protected final boolean enableReplaceObject(boolean enable) throws SecurityException {
        throw new SecurityException("Object replacement may not be controlled in this context");
    }

    @Override
    protected final void writeStreamHeader() throws IOException {
        throw new IllegalStateException("Stream header may not be written in this context");
    }

    @Override
    protected final void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        throw new IllegalStateException("Class descriptor may not be written in this context");
    }

    @Override
    protected final void drain() throws IOException {
        throw new IllegalStateException("Output may not be drained in this context");
    }

    @Override
    public abstract void writeFields() throws IOException;

    @Override
    public abstract ObjectOutputStream.PutField putFields() throws IOException;

    @Override
    public abstract void defaultWriteObject() throws IOException;
}

