/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.Date;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class DateBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = LoggerFactory.make();

    DateBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (Date.class.isAssignableFrom(context.getReturnType())) {
            if (annotatedElement.isAnnotationPresent(DateBridge.class)) {
                DateBridge dateBridgeAnnotation = annotatedElement.getAnnotation(DateBridge.class);
                Resolution resolution = dateBridgeAnnotation.resolution();
                EncodingType encodingType = dateBridgeAnnotation.encoding();
                return this.getDateFieldBridge(resolution, encodingType);
            }
            return this.getDateFieldBridge(Resolution.MILLISECOND, EncodingType.NUMERIC);
        }
        return null;
    }

    private FieldBridge getDateFieldBridge(Resolution resolution, EncodingType encodingType) {
        switch (encodingType) {
            case NUMERIC: {
                switch (resolution) {
                    case YEAR: {
                        return NumericEncodingDateBridge.DATE_YEAR;
                    }
                    case MONTH: {
                        return NumericEncodingDateBridge.DATE_MONTH;
                    }
                    case DAY: {
                        return NumericEncodingDateBridge.DATE_DAY;
                    }
                    case HOUR: {
                        return NumericEncodingDateBridge.DATE_HOUR;
                    }
                    case MINUTE: {
                        return NumericEncodingDateBridge.DATE_MINUTE;
                    }
                    case SECOND: {
                        return NumericEncodingDateBridge.DATE_SECOND;
                    }
                    case MILLISECOND: {
                        return NumericEncodingDateBridge.DATE_MILLISECOND;
                    }
                }
                throw LOG.unknownResolution(resolution.toString());
            }
            case STRING: {
                switch (resolution) {
                    case YEAR: {
                        return StringEncodingDateBridge.DATE_YEAR;
                    }
                    case MONTH: {
                        return StringEncodingDateBridge.DATE_MONTH;
                    }
                    case DAY: {
                        return StringEncodingDateBridge.DATE_DAY;
                    }
                    case HOUR: {
                        return StringEncodingDateBridge.DATE_HOUR;
                    }
                    case MINUTE: {
                        return StringEncodingDateBridge.DATE_MINUTE;
                    }
                    case SECOND: {
                        return StringEncodingDateBridge.DATE_SECOND;
                    }
                    case MILLISECOND: {
                        return StringEncodingDateBridge.DATE_MILLISECOND;
                    }
                }
                throw LOG.unknownResolution(resolution.toString());
            }
        }
        throw LOG.unknownEncodingType(encodingType.name());
    }
}

