/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.filter.impl.CachingWrapperFilter;
import org.hibernate.search.filter.impl.ChainedFilter;
import org.hibernate.search.filter.impl.DefaultFilterKey;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.query.engine.impl.DocumentExtractorImpl;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.FilterCacheModeTypeHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HSQueryImpl
implements HSQuery,
Serializable {
    private static final Log log = LoggerFactory.make();
    private static final FullTextFilterImplementor[] EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR = new FullTextFilterImplementor[0];
    private transient ExtendedSearchIntegrator extendedIntegrator;
    private Query luceneQuery;
    private List<Class<?>> targetedEntities;
    private transient TimeoutManagerImpl timeoutManager;
    private Set<Class<?>> indexedTargetedEntities;
    private boolean allowFieldSelectionInProjection = true;
    private final Map<String, FullTextFilterImpl> filterDefinitions = CollectionHelper.newHashMap();
    private Filter filter;
    private Filter userFilter;
    private Sort sort;
    private String[] projectedFields;
    private int firstResult;
    private int maxResults;
    private boolean definedMaxResults = false;
    private transient Set<Class<?>> classesAndSubclasses;
    private boolean needClassFilterClause;
    private Set<String> idFieldNames;
    private boolean useFieldCacheOnClassTypes = false;
    private transient FacetManagerImpl facetManager;
    private transient TimeoutExceptionFactory timeoutExceptionFactory;
    private Coordinates spatialSearchCenter = null;
    private String spatialFieldName = null;
    private Integer resultSize;
    private String tenantId;

    public HSQueryImpl(ExtendedSearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator;
        this.timeoutExceptionFactory = extendedIntegrator.getDefaultTimeoutExceptionFactory();
    }

    @Override
    public void afterDeserialise(SearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator.unwrap(ExtendedSearchIntegrator.class);
    }

    @Override
    public HSQuery setSpatialParameters(Coordinates center, String fieldName) {
        this.spatialSearchCenter = center;
        this.spatialFieldName = fieldName;
        return this;
    }

    @Override
    public HSQuery tenantIdentifier(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public HSQuery luceneQuery(Query query) {
        this.clearCachedResults();
        this.luceneQuery = query;
        return this;
    }

    @Override
    public HSQuery targetedEntities(List<Class<?>> classes) {
        this.clearCachedResults();
        this.targetedEntities = classes == null ? new ArrayList(0) : new ArrayList(classes);
        Class[] classesAsArray = this.targetedEntities.toArray(new Class[this.targetedEntities.size()]);
        this.indexedTargetedEntities = this.extendedIntegrator.getIndexedTypesPolymorphic(classesAsArray);
        if (this.targetedEntities.size() > 0 && this.indexedTargetedEntities.size() == 0) {
            throw log.targetedEntityTypesNotIndexed(StringHelper.join(this.targetedEntities, ","));
        }
        return this;
    }

    @Override
    public HSQuery sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public HSQuery filter(Filter filter) {
        this.clearCachedResults();
        this.userFilter = filter;
        return this;
    }

    @Override
    public HSQuery timeoutExceptionFactory(TimeoutExceptionFactory exceptionFactory) {
        this.timeoutExceptionFactory = exceptionFactory;
        return this;
    }

    @Override
    public HSQuery projection(String ... fields) {
        this.projectedFields = fields == null || fields.length == 0 ? null : fields;
        return this;
    }

    @Override
    public HSQuery firstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public HSQuery maxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
        this.definedMaxResults = true;
        return this;
    }

    @Override
    public List<Class<?>> getTargetedEntities() {
        return this.targetedEntities;
    }

    @Override
    public Set<Class<?>> getIndexedTargetedEntities() {
        return this.indexedTargetedEntities;
    }

    @Override
    public String[] getProjectedFields() {
        return this.projectedFields;
    }

    private TimeoutManagerImpl getTimeoutManagerImpl() {
        if (this.timeoutManager == null) {
            if (this.luceneQuery == null) {
                throw new AssertionFailure("Requesting TimeoutManager before setting luceneQuery()");
            }
            this.timeoutManager = new TimeoutManagerImpl(this.luceneQuery, this.timeoutExceptionFactory, this.extendedIntegrator.getTimingSource());
        }
        return this.timeoutManager;
    }

    @Override
    public TimeoutManager getTimeoutManager() {
        return this.getTimeoutManagerImpl();
    }

    @Override
    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl(this);
        }
        return this.facetManager;
    }

    @Override
    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    @Override
    public List<EntityInfo> queryEntityInfos() {
        LazyQueryState searcher = this.buildSearcher();
        if (searcher == null) {
            return Collections.emptyList();
        }
        try {
            int size;
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.getFirstResultIndex();
            int max = this.max(first, queryHits.getTotalHits());
            int n = size = max - first + 1 < 0 ? 0 : max - first + 1;
            if (size == 0) {
                List<EntityInfo> list = Collections.emptyList();
                return list;
            }
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = this.buildDocumentExtractor(searcher, queryHits, first, max);
            for (int index = first; index <= max; ++index) {
                infos.add(extractor.extract(index));
                if (index % 10 != 0) continue;
                this.getTimeoutManager().isTimedOut();
            }
            ArrayList<EntityInfo> arrayList = infos;
            return arrayList;
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
    }

    private DocumentExtractor buildDocumentExtractor(LazyQueryState searcher, QueryHits queryHits, int first, int max) {
        return new DocumentExtractorImpl(queryHits, this.extendedIntegrator, this.projectedFields, this.idFieldNames, this.allowFieldSelectionInProjection, searcher, this.luceneQuery, first, max, this.classesAndSubclasses);
    }

    @Override
    public DocumentExtractor queryDocumentExtractor() {
        LazyQueryState openSearcher = this.buildSearcher();
        try {
            QueryHits queryHits = this.getQueryHits(openSearcher, this.calculateTopDocsRetrievalSize());
            int first = this.getFirstResultIndex();
            int max = this.max(first, queryHits.getTotalHits());
            return this.buildDocumentExtractor(openSearcher, queryHits, first, max);
        }
        catch (IOException e) {
            this.closeSearcher(openSearcher);
            throw new SearchException("Unable to query Lucene index", e);
        }
    }

    @Override
    public int queryResultSize() {
        if (this.resultSize == null) {
            this.getTimeoutManager().start();
            LazyQueryState searcher = this.buildSearcher(this.extendedIntegrator, false);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    QueryHits queryHits = this.getQueryHits(searcher, 0);
                    this.resultSize = queryHits.getTotalHits();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to query Lucene index", e);
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }
        }
        return this.resultSize;
    }

    @Override
    public Explanation explain(int documentId) {
        Explanation explanation = null;
        LazyQueryState searcher = this.buildSearcher(this.extendedIntegrator, true);
        if (searcher == null) {
            throw new SearchException("Unable to build explanation for document id:" + documentId + ". no index found");
        }
        try {
            Query filteredQuery = this.filterQueryByTenantId(this.filterQueryByClasses(this.luceneQuery));
            this.buildFilters();
            explanation = searcher.explain(filteredQuery, documentId);
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index and build explanation", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
        return explanation;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        this.clearCachedResults();
        FullTextFilterImpl filterDefinition = this.filterDefinitions.get(name);
        if (filterDefinition != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.extendedIntegrator.getFilterDefinition(name);
        if (filterDef == null) {
            throw log.unknownFullTextFilter(name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.clearCachedResults();
        this.filterDefinitions.remove(name);
    }

    private void closeSearcher(LazyQueryState searcherWithPayload) {
        if (searcherWithPayload == null) {
            return;
        }
        searcherWithPayload.close();
    }

    void clearCachedResults() {
        this.resultSize = null;
    }

    private QueryHits getQueryHits(LazyQueryState searcher, Integer n) throws IOException {
        this.buildFilters();
        boolean stats = this.extendedIntegrator.getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.nanoTime();
        }
        QueryHits queryHits = n == null ? new QueryHits(searcher, this.filter, this.sort, this.getTimeoutManagerImpl(), this.facetManager.getFacetRequests(), this.useFieldCacheOnTypes(), this.getAppropriateIdFieldCollectorFactory(), this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName) : (0 == n ? new QueryHits(searcher, this.filter, null, 0, this.getTimeoutManagerImpl(), null, false, null, this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName) : new QueryHits(searcher, this.filter, this.sort, n, this.getTimeoutManagerImpl(), this.facetManager.getFacetRequests(), this.useFieldCacheOnTypes(), this.getAppropriateIdFieldCollectorFactory(), this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName));
        this.resultSize = queryHits.getTotalHits();
        if (stats) {
            this.extendedIntegrator.getStatisticsImplementor().searchExecuted(searcher.describeQuery(), System.nanoTime() - startTime);
        }
        this.facetManager.setFacetResults(queryHits.getFacets());
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (!this.definedMaxResults) {
            return null;
        }
        long tmpMaxResult = (long)this.getFirstResultIndex() + (long)this.maxResults;
        if (tmpMaxResult >= Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        if (tmpMaxResult == 0L) {
            return 1;
        }
        return (int)tmpMaxResult;
    }

    private int getFirstResultIndex() {
        return this.firstResult;
    }

    private LazyQueryState buildSearcher() {
        return this.buildSearcher(this.extendedIntegrator, null);
    }

    private LazyQueryState buildSearcher(ExtendedSearchIntegrator extendedIntegrator, Boolean forceScoring) {
        Map<Class<?>, EntityIndexBinding> indexBindings = extendedIntegrator.getIndexBindings();
        ArrayList<IndexManager> targetedIndexes = new ArrayList<IndexManager>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        if (this.indexedTargetedEntities.size() == 0) {
            if (indexBindings.isEmpty()) {
                throw new SearchException("There are no mapped entities. Don't forget to add @Indexed to at least one class.");
            }
            for (EntityIndexBinding entityIndexBinding : indexBindings.values()) {
                DocumentBuilderIndexedEntity builder = entityIndexBinding.getDocumentBuilder();
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, entityIndexBinding.getSimilarity());
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                this.useFieldCacheOnClassTypes = this.useFieldCacheOnClassTypes || builder.getFieldCacheOption().contains((Object)FieldCacheType.CLASS);
                this.populateIndexManagers(targetedIndexes, entityIndexBinding.getSelectionStrategy());
            }
            this.classesAndSubclasses = null;
        } else {
            DocumentBuilderIndexedEntity builder;
            HashSet involvedClasses = new HashSet(this.indexedTargetedEntities.size());
            involvedClasses.addAll(this.indexedTargetedEntities);
            for (Class<Object> clazz : this.indexedTargetedEntities) {
                EntityIndexBinding indexBinder = indexBindings.get(clazz);
                if (indexBinder == null) continue;
                builder = indexBinder.getDocumentBuilder();
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class<Object> clazz : involvedClasses) {
                EntityIndexBinding entityIndexBinding = indexBindings.get(clazz);
                if (entityIndexBinding == null) {
                    throw new SearchException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                builder = entityIndexBinding.getDocumentBuilder();
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, entityIndexBinding.getSimilarity());
                this.useFieldCacheOnClassTypes = this.useFieldCacheOnClassTypes || builder.getFieldCacheOption().contains((Object)FieldCacheType.CLASS);
                this.populateIndexManagers(targetedIndexes, entityIndexBinding.getSelectionStrategy());
            }
            this.classesAndSubclasses = involvedClasses;
        }
        this.idFieldNames = idFieldNames;
        if (this.classesAndSubclasses != null) {
            for (IndexManager indexManager : targetedIndexes) {
                Set<Class<?>> classesInIndexManager = indexManager.getContainedTypes();
                if (classesInIndexManager.size() > 1) {
                    for (Class<?> clazz : classesInIndexManager) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        } else {
            this.classesAndSubclasses = extendedIntegrator.getIndexedTypes();
        }
        IndexManager[] indexManagers = targetedIndexes.toArray(new IndexManager[targetedIndexes.size()]);
        IndexReader compoundReader = MultiReaderFactory.openReader(indexManagers);
        Query filteredQuery = this.filterQueryByTenantId(this.filterQueryByClasses(this.luceneQuery));
        String[] projection = this.projectedFields;
        if (Boolean.TRUE.equals(forceScoring)) {
            return new LazyQueryState(filteredQuery, compoundReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, true, true);
        }
        if (Boolean.FALSE.equals(forceScoring)) {
            return new LazyQueryState(filteredQuery, compoundReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, false, false);
        }
        if (this.sort != null && projection != null) {
            boolean activate = false;
            for (String field : projection) {
                if (!"__HSearch_Score".equals(field)) continue;
                activate = true;
                break;
            }
            if (activate) {
                return new LazyQueryState(filteredQuery, compoundReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, true, false);
            }
        }
        return new LazyQueryState(filteredQuery, compoundReader, searcherSimilarity, extendedIntegrator, this.classesAndSubclasses, false, false);
    }

    private Similarity checkSimilarity(Similarity similarity, Similarity entitySimilarity) {
        if (similarity == null) {
            similarity = entitySimilarity;
        } else if (!similarity.getClass().equals(entitySimilarity.getClass())) {
            throw new SearchException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + entitySimilarity.getClass().getName() + ")");
        }
        return similarity;
    }

    private void populateIndexManagers(List<IndexManager> indexManagersTarget, IndexShardingStrategy indexShardingStrategy) {
        IndexManager[] indexManagersForQuery = this.filterDefinitions != null && !this.filterDefinitions.isEmpty() ? indexShardingStrategy.getIndexManagersForQuery(this.filterDefinitions.values().toArray(new FullTextFilterImplementor[this.filterDefinitions.size()])) : indexShardingStrategy.getIndexManagersForQuery(EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR);
        for (IndexManager indexManager : indexManagersForQuery) {
            if (indexManagersTarget.contains(indexManager)) continue;
            indexManagersTarget.add(indexManager);
        }
    }

    private void buildFilters() {
        ChainedFilter chainedFilter = new ChainedFilter();
        if (!this.filterDefinitions.isEmpty()) {
            for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
                Filter filter = this.buildLuceneFilter(fullTextFilter);
                if (filter == null) continue;
                chainedFilter.addFilter(filter);
            }
        }
        if (this.userFilter != null) {
            chainedFilter.addFilter(this.userFilter);
        }
        if (this.getFacetManager().getFacetFilter() != null) {
            chainedFilter.addFilter(this.facetManager.getFacetFilter());
        }
        this.filter = chainedFilter.isEmpty() ? null : chainedFilter;
    }

    private Filter buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        FilterDef def = this.extendedIntegrator.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        if (!FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
            Object filterOrFactory = this.createFilterInstance(fullTextFilter, def);
            return this.createFilter(def, filterOrFactory);
        }
        return this.createOrGetLuceneFilterFromCache(fullTextFilter, def);
    }

    private Filter createOrGetLuceneFilterFromCache(FullTextFilterImpl fullTextFilter, FilterDef def) {
        boolean hasCustomKey = def.getKeyMethod() != null;
        Object filterOrFactory = hasCustomKey ? this.createFilterInstance(fullTextFilter, def) : null;
        FilterKey key = this.createFilterKey(def, filterOrFactory, fullTextFilter);
        Filter filter = this.extendedIntegrator.getFilterCachingStrategy().getCachedFilter(key);
        if (filter == null) {
            filter = this.createFilter(def, hasCustomKey ? filterOrFactory : this.createFilterInstance(fullTextFilter, def));
            this.extendedIntegrator.getFilterCachingStrategy().addCachedFilter(key, filter);
        }
        return filter;
    }

    private boolean isPreQueryFilterOnly(FilterDef def) {
        return def.getImpl().equals(ShardSensitiveOnlyFilter.class);
    }

    private Filter createFilter(FilterDef def, Object filterOrFactory) {
        Filter filter;
        if (def.getFactoryMethod() != null) {
            try {
                filter = (Filter)def.getFactoryMethod().invoke(filterOrFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (ClassCastException e) {
                throw new SearchException("Factory method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
        }
        try {
            filter = (Filter)filterOrFactory;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not implement the Filter interface: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), e);
        }
        filter = this.addCachingWrapperFilter(filter, def);
        return filter;
    }

    private Filter addCachingWrapperFilter(Filter filter, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults(def.getCacheMode())) {
            int cachingWrapperFilterSize = this.extendedIntegrator.getFilterCacheBitResultsSize();
            filter = new CachingWrapperFilter(filter, cachingWrapperFilterSize);
        }
        return filter;
    }

    private FilterKey createFilterKey(FilterDef def, Object filterOrFactory, FullTextFilterImpl fullTextFilter) {
        FilterKey key = null;
        if (def.getKeyMethod() == null) {
            key = new DefaultFilterKey(def.getName(), fullTextFilter.getParameters());
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(filterOrFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            key.setImpl(def.getImpl());
            StandardFilterKey wrapperKey = new StandardFilterKey();
            wrapperKey.addParameter(def.getName());
            wrapperKey.addParameter(key);
            key = wrapperKey;
        }
        return key;
    }

    private Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance = ClassLoaderHelper.instanceFromClass(Object.class, def.getImpl(), "@FullTextFilterDef");
        for (Map.Entry<String, Object> entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke(entry.getKey(), instance, entry.getValue());
        }
        return instance;
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class<?> clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((Query)classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private Query filterQueryByTenantId(Query luceneQuery) {
        if (this.tenantId == null) {
            return luceneQuery;
        }
        TermQuery tenantIdFilter = new TermQuery(new Term("__HSearch_TenantId", this.tenantId));
        tenantIdFilter.setBoost(0.0f);
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((Query)tenantIdFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private int max(int first, int totalHits) {
        if (!this.definedMaxResults) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }

    @Override
    public ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return this.extendedIntegrator;
    }

    private boolean useFieldCacheOnTypes() {
        if (this.classesAndSubclasses.size() <= 1) {
            return false;
        }
        return this.useFieldCacheOnClassTypes;
    }

    private FieldCacheCollectorFactory getAppropriateIdFieldCollectorFactory() {
        Map<Class<?>, EntityIndexBinding> builders = this.extendedIntegrator.getIndexBindings();
        HashSet<FieldCacheCollectorFactory> allCollectors = new HashSet<FieldCacheCollectorFactory>();
        FieldCacheCollectorFactory anyImplementation = null;
        for (Class<?> clazz : this.classesAndSubclasses) {
            EntityIndexBinding docBuilder = builders.get(clazz);
            FieldCacheCollectorFactory fieldCacheCollectionFactory = docBuilder.getIdFieldCacheCollectionFactory();
            if (fieldCacheCollectionFactory == null) {
                return null;
            }
            anyImplementation = fieldCacheCollectionFactory;
            allCollectors.add(fieldCacheCollectionFactory);
        }
        if (allCollectors.size() != 1) {
            return null;
        }
        return anyImplementation;
    }
}

