/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.Type;
import org.jboss.weld.util.reflection.Reflections;

public class RawType<T>
implements Type {
    private final Class<T> type;

    public static Type wrap(Type type) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).getTypeParameters().length > 0) {
            return RawType.of(clazz);
        }
        return type;
    }

    public static Type unwrap(Type type) {
        if (type instanceof RawType) {
            return ((RawType)Reflections.cast(type)).getType();
        }
        return type;
    }

    public static <T> RawType<T> of(Class<T> type) {
        return new RawType<T>(type);
    }

    private RawType(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String toString() {
        return "RawType [clazz=" + this.type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawType other = (RawType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

