/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts.service;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.narayana.rest.bridge.inbound.InboundBridge;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeOrphanFilter;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeRecoveryModule;

public class InboundBridgeService
implements Service<InboundBridgeService> {
    private static final Logger LOG = Logger.getLogger(InboundBridgeService.class);
    private RecoveryModule recoveryModule;
    private XAResourceOrphanFilter orphanFilter;

    public void start(StartContext startContext) throws StartException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeService.start");
        }
        this.addDeserializerAndOrphanFilter();
        this.addRecoveryModule();
    }

    public void stop(StopContext stopContext) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeService.stop");
        }
        this.removeOrphanFilter();
        this.removeRecoveryModule();
    }

    public InboundBridgeService getValue() throws IllegalStateException, IllegalArgumentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridgeService.getValue");
        }
        return this;
    }

    private void addDeserializerAndOrphanFilter() {
        RecoveryManager recoveryManager = RecoveryManager.manager();
        for (RecoveryModule recoveryModule : recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            this.orphanFilter = new InboundBridgeOrphanFilter();
            ((XARecoveryModule)recoveryModule).addXAResourceOrphanFilter(this.orphanFilter);
            ((XARecoveryModule)recoveryModule).addSerializableXAResourceDeserializer((SerializableXAResourceDeserializer)new InboundBridge());
        }
    }

    private void removeOrphanFilter() {
        if (this.orphanFilter == null) {
            return;
        }
        RecoveryManager recoveryManager = RecoveryManager.manager();
        for (RecoveryModule recoveryModule : recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            ((XARecoveryModule)recoveryModule).removeXAResourceOrphanFilter(this.orphanFilter);
        }
    }

    private void addRecoveryModule() {
        RecoveryManager recoveryManager = RecoveryManager.manager();
        this.recoveryModule = new InboundBridgeRecoveryModule();
        recoveryManager.addModule(this.recoveryModule);
    }

    private void removeRecoveryModule() {
        if (this.recoveryModule == null) {
            return;
        }
        RecoveryManager recoveryManager = RecoveryManager.manager();
        recoveryManager.removeModule(this.recoveryModule, false);
    }
}

