/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;

public class MethodHashing {
    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuilder methodDesc = new StringBuilder(method.getName()).append("(");
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc.append(MethodHashing.getTypeString(parameterTypes[j]));
        }
        methodDesc.append(")").append(MethodHashing.getTypeString(method.getReturnType()));
        return MethodHashing.createHash(methodDesc.toString());
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    static String getTypeString(Class<?> cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MethodHashing.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }
}

