/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow.metric;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.wildfly.mod_cluster.undertow.metric.jdk8backported.LongAdder;

public class RunningRequestsHttpHandler
implements HttpHandler {
    private static final LongAdder runningCount = new LongAdder();
    private final HttpHandler wrappedHandler;

    public RunningRequestsHttpHandler(HttpHandler handler) {
        this.wrappedHandler = handler;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        runningCount.increment();
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                runningCount.decrement();
                nextListener.proceed();
            }
        });
        this.wrappedHandler.handleRequest(exchange);
    }

    public static int getRunningRequestCount() {
        return runningCount.intValue();
    }
}

