/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractOneToOneMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractToOneMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.AuditEntity;

public class OneToOneNotOwningMapper
extends AbstractOneToOneMapper {
    private final String owningReferencePropertyName;

    public OneToOneNotOwningMapper(String notOwningEntityName, String owningEntityName, String owningReferencePropertyName, PropertyData propertyData) {
        super(notOwningEntityName, owningEntityName, propertyData);
        this.owningReferencePropertyName = owningReferencePropertyName;
    }

    @Override
    protected Object queryForReferencedEntity(AuditReaderImplementor versionsReader, AbstractToOneMapper.EntityInfo referencedEntity, Serializable primaryKey, Number revision) {
        return versionsReader.createQuery().forEntitiesAtRevision(referencedEntity.getEntityClass(), referencedEntity.getEntityName(), revision).add(AuditEntity.relatedId(this.owningReferencePropertyName).eq(primaryKey)).getSingleResult();
    }
}

