/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerRecoveryTopLevelAction;
import com.arjuna.ats.internal.jts.recovery.contact.StatusChecker;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.io.IOException;
import java.util.Date;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class RecoveredServerTransaction
extends ServerTransaction
implements RecoveringTransaction {
    protected Uid _originalProcessUid;
    private String _typeName;
    private boolean _reportHeuristics = false;
    private int _recoveryStatus = 0;
    private Status _txStatus;

    public RecoveredServerTransaction(Uid actionUid) {
        this(actionUid, "");
    }

    public RecoveredServerTransaction(Uid actionUid, String changedTypeName) {
        super(actionUid);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredServerTransaction " + this.getSavingUid() + " created"));
        }
        this._recoveryStatus = 2;
        String effectiveTypeName = RecoveredServerTransaction.typeName();
        if (changedTypeName.length() < 1) {
            this._typeName = null;
        } else {
            this._typeName = changedTypeName;
            effectiveTypeName = changedTypeName;
        }
        this._originalProcessUid = new Uid(Uid.nullUid());
        try {
            if (StoreManager.getRecoveryStore().currentState(this.getSavingUid(), effectiveTypeName) != -1) {
                if (this.activate()) {
                    this._recoveryStatus = 1;
                } else {
                    jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_2(this.getSavingUid());
                }
            }
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_2(this.getSavingUid());
        }
        this._txStatus = Status.StatusUnknown;
    }

    @Override
    public synchronized Status get_status() throws SystemException {
        if (this._txStatus != Status.StatusUnknown) {
            return this._txStatus;
        }
        Status theStatus = Status.StatusUnknown;
        theStatus = this._recoveryStatus == 2 ? Status.StatusRolledBack : super.get_status();
        return theStatus;
    }

    @Override
    public void addResourceRecord(Uid rcUid, Resource r) {
        Coordinator coord = null;
        AbstractRecord corbaRec = this.createOTSRecord(true, r, coord, rcUid);
        this.addRecord(corbaRec);
    }

    @Override
    public void replayPhase2() {
        this._recoveryStatus = 3;
        Status theStatus = this.get_status();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredServerTransaction.replayPhase2(" + this.get_uid() + ") - status = " + Utility.stringStatus(theStatus)));
        }
        if (theStatus == Status.StatusPrepared) {
            theStatus = this.getStatusFromParent();
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug((Object)("RecoveredServerTransaction.replayPhase2(" + this.get_uid() + ") -" + " status after contacting parent = " + Utility.stringStatus(theStatus)));
            }
        }
        if (theStatus == Status.StatusCommitting || theStatus == Status.StatusCommitted) {
            this.phase2Commit(this._reportHeuristics);
            this._recoveryStatus = 4;
            this._txStatus = Status.StatusCommitted;
        } else if (theStatus == Status.StatusRolledBack || theStatus == Status.StatusRollingBack || theStatus == Status.StatusMarkedRollback || theStatus == Status.StatusNoTransaction) {
            this.phase2Abort(this._reportHeuristics);
            this._recoveryStatus = 4;
            this._txStatus = Status.StatusRolledBack;
        } else if (theStatus == Status.StatusUnknown) {
            jtsLogger.i18NLogger.info_recovery_transactions_RecoveredServerTransaction_6(this.get_uid());
            this._recoveryStatus = 5;
        } else {
            jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_7(Utility.stringStatus(theStatus));
            this._recoveryStatus = 5;
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredServerTransaction.replayPhase2: (" + this.get_uid() + ") finished"));
        }
    }

    @Override
    public int getRecoveryStatus() {
        return this._recoveryStatus;
    }

    @Override
    public Status getOriginalStatus() {
        if (this._recoveryStatus != 2) {
            try {
                return StatusChecker.get_status(this.get_uid(), this._originalProcessUid);
            }
            catch (Inactive ex) {
                return Status.StatusUnknown;
            }
        }
        return Status.StatusUnknown;
    }

    private Status getStatusFromParent() {
        Status theStatus = Status.StatusUnknown;
        if (this._recoveryCoordinator != null && this.get_status() == Status.StatusPrepared) {
            ServerControl sc = new ServerControl(this);
            ServerRecoveryTopLevelAction tla = new ServerRecoveryTopLevelAction(sc);
            if (tla.valid()) {
                try {
                    theStatus = this._recoveryCoordinator.replay_completion(tla.getReference());
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug((Object)("RecoveredServerTransaction.getStatusFromParent - replay_completion status = " + Utility.stringStatus(theStatus)));
                    }
                }
                catch (TRANSIENT ex_trans) {
                    jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_10(this.get_uid());
                    theStatus = Status.StatusUnknown;
                }
                catch (OBJECT_NOT_EXIST ex) {
                    theStatus = Status.StatusRolledBack;
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug((Object)("RecoveredServerTransaction.getStatusFromParent - replay_completion got object_not_exist = " + Utility.stringStatus(theStatus)));
                    }
                }
                catch (NotPrepared ex1) {
                    jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_12();
                    theStatus = Status.StatusActive;
                }
                catch (Exception e) {
                    jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_13(e);
                }
            } else {
                jtsLogger.i18NLogger.warn_recovery_transactions_RecoveredServerTransaction_14(this.get_uid());
            }
            sc = null;
            tla = null;
        } else if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)"RecoveredServerTransaction:getStatusFromParent - no recovcoord or status not prepared");
        }
        return theStatus;
    }

    @Override
    public boolean allCompleted() {
        return false;
    }

    @Override
    public String type() {
        if (this._typeName == null) {
            return super.type();
        }
        return this._typeName;
    }

    @Override
    public void removeOldStoreEntry() {
        try {
            this.getStore().remove_committed(this.getSavingUid(), super.type());
        }
        catch (ObjectStoreException ex) {
            jtsLogger.i18NLogger.warn_recoveredServerTransaction_removeOldStoreEntry(ex);
        }
    }

    @Override
    public boolean assumeComplete() {
        this._typeName = AssumedCompleteServerTransaction.typeName();
        return true;
    }

    @Override
    protected void packHeader(OutputObjectState os, Header hdr) throws IOException {
        super.packHeader(os, new Header(this.get_uid(), this._originalProcessUid));
    }

    @Override
    protected void unpackHeader(InputObjectState os, Header hdr) throws IOException {
        super.unpackHeader(os, hdr);
        this._originalProcessUid = hdr.getProcessId();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("RecoveredServerTransaction.unpackHeader - txid = " + this.get_uid() + " and processUid = " + this._originalProcessUid));
        }
    }

    @Override
    public boolean save_state(OutputObjectState objectState, int ot) {
        boolean result = super.save_state(objectState, ot);
        if (this._typeName != null && result) {
            Date lastActiveTime = new Date();
            try {
                objectState.packLong(lastActiveTime.getTime());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Date getLastActiveTime() {
        return null;
    }
}

