/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.ExecutorService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.stat.Statistics;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.Util;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.clustered.ClusteredCacheQueryImpl;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.CacheQueryImpl;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.massindex.DistributedExecutorMassIndexer;
import org.infinispan.query.spi.SearchManagerImplementor;

public class SearchManagerImpl
implements SearchManagerImplementor {
    private final AdvancedCache<?, ?> cache;
    private final SearchIntegrator searchFactory;
    private final QueryInterceptor queryInterceptor;
    private final QueryCache queryCache;
    private TimeoutExceptionFactory timeoutExceptionFactory;

    public SearchManagerImpl(AdvancedCache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.cache = cache;
        this.searchFactory = ComponentRegistryUtils.getComponent(cache, SearchIntegrator.class);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        this.queryCache = ComponentRegistryUtils.getQueryCache(cache);
    }

    @Override
    public QueryFactory<LuceneQuery> getQueryFactory() {
        EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

            public Class<?> getClassFromName(String entityName) {
                Class clazz;
                try {
                    clazz = Util.loadClassStrict((String)entityName, null);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return SearchManagerImpl.this.queryInterceptor.isIndexed(clazz) ? clazz : null;
            }
        };
        return new EmbeddedLuceneQueryFactory(this, this.queryCache, entityNamesResolver);
    }

    @Override
    public CacheQuery getQuery(Query luceneQuery, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, this.queryInterceptor.getKeyTransformationHandler(), this.timeoutExceptionFactory, classes);
    }

    @Override
    public CacheQuery getClusteredQuery(Query luceneQuery, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        return new ClusteredCacheQueryImpl(luceneQuery, this.searchFactory, asyncExecutor, this.cache, this.queryInterceptor.getKeyTransformationHandler(), classes);
    }

    @Override
    public void registerKeyTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.queryInterceptor.registerKeyTransformer(keyClass, transformerClass);
    }

    @Override
    public void setTimeoutExceptionFactory(TimeoutExceptionFactory timeoutExceptionFactory) {
        this.timeoutExceptionFactory = timeoutExceptionFactory;
    }

    @Override
    public EntityContext buildQueryBuilderForClass(Class<?> entityType) {
        this.queryInterceptor.enableClasses(new Class[]{entityType});
        return this.searchFactory.buildQueryBuilder().forEntity(entityType);
    }

    @Override
    @Deprecated
    public SearchIntegrator getSearchFactory() {
        return this.searchFactory;
    }

    @Override
    public MassIndexer getMassIndexer() {
        return new DistributedExecutorMassIndexer(this.cache, this.searchFactory);
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.searchFactory.getAnalyzer(name);
    }

    @Override
    public Statistics getStatistics() {
        return this.searchFactory.getStatistics();
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        return this.searchFactory.getAnalyzer(clazz);
    }

    @Override
    public void purge(Class<?> entityType) {
        this.queryInterceptor.purgeIndex(entityType);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.isAssignableFrom(cls)) {
            return (T)this.searchFactory;
        }
        if (SearchManagerImplementor.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Can not unwrap a SearchManagerImpl into a '" + cls + "'");
    }
}

