/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class HornetQActivationService
implements Service<Void> {
    public static ServiceName getHornetQActivationServiceName(ServiceName hqServerName) {
        return hqServerName.append(new String[]{"activation"});
    }

    public static boolean isHornetQServerActive(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return HornetQActivationService.isHornetQServerActive(context.getServiceRegistry(false), MessagingServices.getHornetQServiceName(address));
    }

    public static boolean isHornetQServerActive(ServiceRegistry serviceRegistry, ServiceName hqServiceName) {
        HornetQServer server;
        ServiceController service = serviceRegistry.getService(hqServiceName);
        return service != null && (server = (HornetQServer)HornetQServer.class.cast(service.getValue())).isStarted() && server.isActive();
    }

    public static boolean rollbackOperationIfServerNotActive(OperationContext context, ModelNode operation) {
        if (HornetQActivationService.isHornetQServerActive(context, operation)) {
            return false;
        }
        context.getFailureDescription().set(MessagingMessages.MESSAGES.hqServerInBackupMode(PathAddress.pathAddress((ModelNode)operation.require("address"))));
        context.setRollbackOnly();
        context.stepCompleted();
        return true;
    }

    public static boolean ignoreOperationIfServerNotActive(OperationContext context, ModelNode operation) {
        if (HornetQActivationService.isHornetQServerActive(context, operation)) {
            return false;
        }
        context.getResult();
        context.stepCompleted();
        return true;
    }

    static HornetQServer getHornetQServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(false).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

