/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.List;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.ProtocolServerService;
import org.infinispan.server.endpoint.subsystem.ProtocolServiceSubsystemAdd;
import org.infinispan.server.websocket.WebSocketServer;
import org.infinispan.server.websocket.configuration.WebSocketServerConfigurationBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

class WebSocketSubsystemAdd
extends ProtocolServiceSubsystemAdd {
    static final WebSocketSubsystemAdd INSTANCE = new WebSocketSubsystemAdd();

    WebSocketSubsystemAdd() {
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        target.setEmptyObject();
        for (SimpleAttributeDefinition attr : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition attr : ProtocolServerConnectorResource.PROTOCOL_SERVICE_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        WebSocketServerConfigurationBuilder configurationBuilder = new WebSocketServerConfigurationBuilder();
        this.configureProtocolServer((ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder, config);
        ProtocolServerService service = new ProtocolServerService(this.getServiceName(operation), (Class<? extends ProtocolServer>)WebSocketServer.class, (ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder);
        ServiceBuilder builder = context.getServiceTarget().addService(EndpointUtils.getServiceName(operation, "websocket"), (Service)service);
        String cacheContainerName = this.getCacheContainerName(operation);
        EndpointUtils.addCacheContainerDependency(builder, cacheContainerName, service.getCacheManager());
        EndpointUtils.addSocketBindingDependency(builder, this.getSocketBindingName(operation), service.getSocketBinding());
        EndpointUtils.addCacheDependency(builder, cacheContainerName, null);
        builder.install();
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        WebSocketSubsystemAdd.populate(source, target);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

