/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.HostEffect;
import org.jboss.as.controller.access.ServerGroupEffect;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;

public final class TargetResource {
    private final PathAddress address;
    private final ImmutableManagementResourceRegistration resourceRegistration;
    private final Resource resource;
    private final ServerGroupEffect serverGroupEffect;
    private final HostEffect hostEffect;
    private final List<AccessConstraintDefinition> accessConstraintDefinitions;

    public static TargetResource forStandalone(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration, Resource resource) {
        return new TargetResource(address, resourceRegistration, resource, null, null);
    }

    public static TargetResource forDomain(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration, Resource resource, ServerGroupEffect serverGroupEffect, HostEffect hostEffect) {
        return new TargetResource(address, resourceRegistration, resource, serverGroupEffect, hostEffect);
    }

    private TargetResource(PathAddress address, ImmutableManagementResourceRegistration resourceRegistration, Resource resource, ServerGroupEffect serverGroupEffect, HostEffect hostEffect) {
        this.address = address;
        this.resourceRegistration = resourceRegistration;
        this.resource = resource;
        this.serverGroupEffect = serverGroupEffect;
        this.hostEffect = hostEffect;
        this.accessConstraintDefinitions = resourceRegistration.getAccessConstraints();
    }

    public PathAddress getResourceAddress() {
        return this.address;
    }

    public ServerGroupEffect getServerGroupEffect() {
        return this.serverGroupEffect;
    }

    public HostEffect getHostEffect() {
        return this.hostEffect;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraintDefinitions;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ImmutableManagementResourceRegistration getResourceRegistration() {
        return this.resourceRegistration;
    }
}

