/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.interfaces.InetAddressMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.LinkLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackInterfaceCriteria;
import org.jboss.as.controller.interfaces.NotInterfaceCriteria;

class CriteriaValidator {
    final Set<InterfaceCriteria> criteria;
    static Validation LOOPBACK_INTERFACE = new Validation(){

        @Override
        public String validate(InterfaceCriteria current, InterfaceCriteria candidate) {
            if (candidate instanceof InetAddressMatchInterfaceCriteria) {
                return ControllerMessages.MESSAGES.cantHaveBothLoopbackAndInetAddressCriteria();
            }
            return null;
        }
    };
    static Validation NOT_INTERFACE = new Validation(){

        @Override
        public String validate(InterfaceCriteria current, InterfaceCriteria candidate) {
            for (InterfaceCriteria curr : ((NotInterfaceCriteria)current).getAllCriteria()) {
                if (!curr.equals(candidate)) continue;
                return ControllerMessages.MESSAGES.cantHaveSameCriteriaForBothNotAndInclusion(candidate);
            }
            return null;
        }
    };

    CriteriaValidator(Set<InterfaceCriteria> criteria) {
        this.criteria = criteria;
    }

    String validate() {
        for (InterfaceCriteria current : this.criteria) {
            Validation validation = this.getValidation(current);
            if (validation == null) continue;
            for (InterfaceCriteria candidate : this.criteria) {
                String error;
                if (current == candidate || (error = validation.validate(current, candidate)) == null) continue;
                return error;
            }
        }
        return null;
    }

    Validation getValidation(InterfaceCriteria criteria) {
        if (criteria instanceof LoopbackInterfaceCriteria) {
            return LOOPBACK_INTERFACE;
        }
        if (criteria instanceof LinkLocalInterfaceCriteria) {
            return null;
        }
        if (criteria instanceof NotInterfaceCriteria) {
            return NOT_INTERFACE;
        }
        return null;
    }

    static interface Validation {
        public String validate(InterfaceCriteria var1, InterfaceCriteria var2);
    }
}

