/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.ifelse.IfElseBlock;

public class ElseHandler
extends CommandHandlerWithHelp {
    public ElseHandler() {
        super("else", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        try {
            IfElseBlock ifBlock = IfElseBlock.get(ctx);
            return ifBlock != null && ifBlock.isInIf();
        }
        catch (CommandLineException e) {
            return false;
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        IfElseBlock ifBlock = IfElseBlock.get(ctx);
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            throw new CommandLineException("if block did not activate batch mode.");
        }
        Batch ifBatch = batchManager.getActiveBatch();
        if (ifBatch.size() == 0) {
            throw new CommandLineException("if block is empty.");
        }
        ifBlock.setIfRequest(ifBatch.toRequest());
        ifBlock.setInElse();
        batchManager.discardActiveBatch();
        if (!batchManager.activateNewBatch()) {
            IfElseBlock.remove(ctx);
            throw new CommandFormatException("Failed to activate batch mode for else.");
        }
    }
}

