/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import javax.ejb.Handle;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeCreateInterceptorFactory;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeFinderInterceptorFactory;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeMethodInterceptorFactory;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeRemoveByHandleInterceptorFactory;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeRemoveInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.ComponentTypeIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.EjbMetadataInterceptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.metadata.ejb.spec.PersistenceType;
import org.jboss.msc.service.ServiceBuilder;

public class EntityBeanHomeViewConfigurator
implements ViewConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, final ViewConfiguration configuration) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        configuration.addClientPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
        configuration.addClientPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
        boolean localHome = ((EjbHomeViewDescription)((Object)EjbHomeViewDescription.class.cast(description))).getMethodIntf() == MethodIntf.LOCAL_HOME;
        EntityBeanComponentDescription componentDescription = (EntityBeanComponentDescription)componentConfiguration.getComponentDescription();
        final EJBViewDescription createdView = localHome ? componentDescription.getEjbLocalView() : componentDescription.getEjbRemoteView();
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        for (Method method : configuration.getProxyFactory().getCachedMethods()) {
            Object factory;
            configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
            if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                configuration.addClientInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 1024);
                continue;
            }
            if (method.getName().equals("hashCode") && method.getParameterTypes().length == 0) {
                configuration.addClientInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 1024);
                continue;
            }
            if (method.getName().equals("toString") && method.getParameterTypes().length == 0) continue;
            if (method.getName().startsWith("create")) {
                Method ejbCreate = this.resolveEjbMethod("create", "ejbCreate", componentDescription.getPrimaryKeyType(), componentConfiguration.getComponentClass(), deploymentReflectionIndex, method, componentConfiguration.getComponentName());
                Method ejbPostCreate = this.resolveEjbMethod("create", "ejbPostCreate", Void.TYPE.getName(), componentConfiguration.getComponentClass(), deploymentReflectionIndex, method, componentConfiguration.getComponentName());
                factory = new EntityBeanHomeCreateInterceptorFactory(ejbCreate, ejbPostCreate);
                configuration.getDependencies().add(new DependencyConfigurator<ViewService>((EntityBeanHomeCreateInterceptorFactory)factory){
                    final /* synthetic */ EntityBeanHomeCreateInterceptorFactory val$factory;
                    {
                        this.val$factory = entityBeanHomeCreateInterceptorFactory;
                    }

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ViewService service) throws DeploymentUnitProcessingException {
                        serviceBuilder.addDependency(createdView.getServiceName(), ComponentView.class, this.val$factory.getViewToCreate());
                    }
                });
                configuration.addViewInterceptor(method, (InterceptorFactory)factory, 1536);
                continue;
            }
            if (method.getName().startsWith("find")) {
                Method ejbFind = this.resolveEjbFinderMethod(componentConfiguration.getComponentClass(), deploymentReflectionIndex, method, componentConfiguration.getComponentName(), componentDescription.getPersistenceType());
                if (!Modifier.isPublic(ejbFind.getModifiers())) {
                    throw EjbMessages.MESSAGES.ejbMethodMustBePublic("ejbFind", ejbFind);
                }
                final EntityBeanHomeFinderInterceptorFactory interceptorFactory = this.createHomeFindInterceptorFactory(ejbFind, localHome);
                configuration.getDependencies().add(new DependencyConfigurator<ViewService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ViewService service) throws DeploymentUnitProcessingException {
                        serviceBuilder.addDependency(createdView.getServiceName(), ComponentView.class, interceptorFactory.getViewToCreate());
                    }
                });
                configuration.addViewInterceptor(method, (InterceptorFactory)interceptorFactory, 2560);
                continue;
            }
            if (method.getName().equals("remove") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                configuration.addViewInterceptor(method, EntityBeanHomeRemoveInterceptorFactory.instance(!localHome), 2560);
                continue;
            }
            if (method.getName().equals("remove") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Handle.class) {
                configuration.addViewInterceptor(method, (InterceptorFactory)EntityBeanHomeRemoveByHandleInterceptorFactory.INSTANCE, 2560);
                continue;
            }
            if (method.getName().equals("getEJBMetaData") && method.getParameterTypes().length == 0) {
                Class pkClass;
                Class ejbObjectClass;
                try {
                    ejbObjectClass = classIndex.classIndex(createdView.getViewClassName()).getModuleClass();
                    pkClass = classIndex.classIndex(componentDescription.getPrimaryKeyType()).getModuleClass();
                }
                catch (ClassNotFoundException e) {
                    throw EjbMessages.MESSAGES.failedToLoadViewClassForComponent(e, componentDescription.getComponentName());
                }
                factory = new EjbMetadataInterceptor(ejbObjectClass, configuration.getViewClass(), pkClass, false, false);
                componentConfiguration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>((EjbMetadataInterceptor)factory){
                    final /* synthetic */ EjbMetadataInterceptor val$factory;
                    {
                        this.val$factory = ejbMetadataInterceptor;
                    }

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                        serviceBuilder.addDependency(configuration.getViewServiceName(), ComponentView.class, this.val$factory.getHomeView());
                    }
                });
                configuration.addViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)factory), 1536);
                continue;
            }
            if (method.getName().equals("getHomeHandle") && method.getParameterTypes().length == 0) continue;
            Method home = this.resolveEjbHomeBusinessMethod(componentConfiguration.getComponentClass(), deploymentReflectionIndex, method, componentConfiguration.getComponentName());
            if (!Modifier.isPublic(home.getModifiers())) {
                throw EjbMessages.MESSAGES.ejbMethodMustBePublic("ejbHome", home);
            }
            configuration.addViewInterceptor(method, (InterceptorFactory)new EntityBeanHomeMethodInterceptorFactory(home), 2560);
        }
    }

    protected EntityBeanHomeFinderInterceptorFactory createHomeFindInterceptorFactory(Method ejbFind, boolean localHome) {
        return new EntityBeanHomeFinderInterceptorFactory(ejbFind);
    }

    private Method resolveEjbMethod(String userName, String ejbMethodName, String returnType, Class<?> componentClass, DeploymentReflectionIndex index, Method method, String ejbName) throws DeploymentUnitProcessingException {
        String name = method.getName().replaceFirst(userName, ejbMethodName);
        for (Class<?> clazz = componentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            ClassReflectionIndex classIndex = index.getClassIndex(clazz);
            Method ret = classIndex.getMethod(returnType, name, EntityBeanHomeViewConfigurator.namesOf(method.getParameterTypes()));
            if (ret == null) continue;
            return ret;
        }
        throw EjbMessages.MESSAGES.failToResolveMethodForHomeInterface(ejbMethodName, method, ejbName);
    }

    protected Method resolveEjbFinderMethod(Class<?> componentClass, DeploymentReflectionIndex index, Method method, String ejbName, PersistenceType persistenceType) throws DeploymentUnitProcessingException {
        String name = method.getName().replaceFirst("find", "ejbFind");
        for (Class<?> clazz = componentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            ClassReflectionIndex classIndex = index.getClassIndex(clazz);
            Collection methods = classIndex.getMethods(name, (Class[])method.getParameterTypes());
            if (methods.isEmpty()) continue;
            return (Method)methods.iterator().next();
        }
        if (PersistenceType.Bean == persistenceType) {
            throw EjbMessages.MESSAGES.failToResolveMethodForHomeInterface("ejbFind", method, ejbName);
        }
        return method;
    }

    protected Method resolveEjbHomeBusinessMethod(Class<?> componentClass, DeploymentReflectionIndex index, Method method, String ejbName) throws DeploymentUnitProcessingException {
        String name = "ejbHome" + Character.toUpperCase(method.getName().charAt(0)) + method.getName().substring(1);
        for (Class<?> clazz = componentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            ClassReflectionIndex classIndex = index.getClassIndex(clazz);
            Collection methods = classIndex.getMethods(name, (Class[])method.getParameterTypes());
            if (methods.isEmpty()) continue;
            return (Method)methods.iterator().next();
        }
        throw EjbMessages.MESSAGES.failToResolveMethodForHomeInterface("ejbHome", method, ejbName);
    }

    private static String[] namesOf(Class<?>[] types) {
        String[] strings = new String[types.length];
        int typesLength = types.length;
        for (int i = 0; i < typesLength; ++i) {
            strings[i] = types[i].getName();
        }
        return strings;
    }
}

