/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.EJBAccessException;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.security.SecurityRolesAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextInterceptor
implements Interceptor {
    private final PrivilegedAction<Void> pushAction;
    private final PrivilegedAction<Void> popAction;

    public SecurityContextInterceptor(final SecurityContextInterceptorHolder holder) {
        this.pushAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                holder.securityManager.push(holder.securityDomain);
                try {
                    if (!holder.skipAuthentication) {
                        holder.securityManager.authenticate(holder.runAs, holder.runAsPrincipal, holder.extraRoles);
                    }
                    if (holder.principalVsRolesMap != null) {
                        SecurityRolesAssociation.setSecurityRoles(holder.principalVsRolesMap);
                    }
                }
                catch (Throwable t) {
                    if (holder.principalVsRolesMap != null) {
                        SecurityRolesAssociation.setSecurityRoles(null);
                    }
                    holder.securityManager.pop();
                    if (t instanceof SecurityException) {
                        throw new EJBAccessException(t.getMessage());
                    }
                    throw t;
                }
                return null;
            }
        };
        this.popAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (holder.principalVsRolesMap != null) {
                    SecurityRolesAssociation.setSecurityRoles(null);
                }
                holder.securityManager.pop();
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(this.pushAction);
        } else {
            this.pushAction.run();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(this.popAction);
            } else {
                this.popAction.run();
            }
        }
    }
}

