/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.concurrent.handle.ContextHandle;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ClassLoaderContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "CLASSLOADER";
    private final ClassLoader classLoader;

    public ClassLoaderContextHandleFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new ClassLoaderContextHandle(this.classLoader);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 100;
    }

    @Override
    public void writeHandle(ContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public ContextHandle readHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new ClassLoaderContextHandle(this.classLoader);
    }

    private static class ClassLoaderContextHandle
    implements ContextHandle {
        private final ClassLoader classLoader;
        private ClassLoader previous;

        private ClassLoaderContextHandle(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public void setup() throws IllegalStateException {
            this.previous = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
        }

        @Override
        public void reset() {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.previous);
        }

        @Override
        public String getFactoryName() {
            return ClassLoaderContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }
    }
}

