/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;

public class RouterStubManager
implements RouterStub.ConnectionListener {
    private final ConcurrentMap<RouterStub, Future<?>> futures = new ConcurrentHashMap();
    private final List<RouterStub> stubs;
    private final Protocol owner;
    private final TimeScheduler timer;
    private final String channelName;
    private final Address logicalAddress;
    private final long interval;
    protected final Log log;

    public RouterStubManager(Protocol owner, String channelName, Address logicalAddress, long interval) {
        this.owner = owner;
        this.stubs = new CopyOnWriteArrayList<RouterStub>();
        this.log = LogFactory.getLog(owner.getClass());
        this.timer = owner.getTransport().getTimer();
        this.channelName = channelName;
        this.logicalAddress = logicalAddress;
        this.interval = interval;
    }

    private RouterStubManager(Protocol p) {
        this(p, null, null, 0L);
    }

    public List<RouterStub> getStubs() {
        return this.stubs;
    }

    public RouterStub createAndRegisterStub(String routerHost, int routerPort, InetAddress bindAddress) {
        RouterStub s = new RouterStub(routerHost, routerPort, bindAddress, this);
        this.unregisterAndDestroyStub(s);
        this.stubs.add(s);
        return s;
    }

    public void registerStub(RouterStub s) {
        this.unregisterAndDestroyStub(s);
        this.stubs.add(s);
    }

    public RouterStub unregisterStub(RouterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Cannot remove null stub");
        }
        RouterStub found = null;
        for (RouterStub s : this.stubs) {
            if (!s.equals(stub)) continue;
            found = s;
            break;
        }
        if (found != null) {
            this.stubs.remove(found);
        }
        return found;
    }

    public boolean unregisterAndDestroyStub(RouterStub stub) {
        RouterStub unregisteredStub = this.unregisterStub(stub);
        if (unregisteredStub != null) {
            unregisteredStub.destroy();
            return true;
        }
        return false;
    }

    public void disconnectStubs() {
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.channelName, this.logicalAddress);
            }
            catch (Exception exception) {}
        }
    }

    public void destroyStubs() {
        for (RouterStub s : this.stubs) {
            this.stopReconnecting(s);
            s.destroy();
        }
        this.stubs.clear();
    }

    public void startReconnecting(final RouterStub stub) {
        Future<?> f = (Future<?>)this.futures.remove(stub);
        if (f != null) {
            f.cancel(true);
        }
        Runnable reconnector = new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (RouterStubManager.this.log.isTraceEnabled()) {
                            RouterStubManager.this.log.trace("Reconnecting " + stub);
                        }
                        String logical_name = UUID.get(RouterStubManager.this.logicalAddress);
                        PhysicalAddress physical_addr = (PhysicalAddress)RouterStubManager.this.owner.down(new Event(87, RouterStubManager.this.logicalAddress));
                        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
                        stub.connect(RouterStubManager.this.channelName, RouterStubManager.this.logicalAddress, logical_name, physical_addrs);
                        if (RouterStubManager.this.log.isTraceEnabled()) {
                            RouterStubManager.this.log.trace("Reconnected " + stub);
                        }
                    }
                    catch (Throwable ex) {
                        if (!RouterStubManager.this.log.isWarnEnabled()) break block4;
                        RouterStubManager.this.log.warn("failed reconnecting stub to GR at " + stub.getGossipRouterAddress() + ": " + ex);
                    }
                }
            }

            public String toString() {
                return RouterStubManager.class.getSimpleName() + ": Reconnector";
            }
        };
        f = this.timer.scheduleWithFixedDelay(reconnector, 0L, this.interval, TimeUnit.MILLISECONDS);
        this.futures.putIfAbsent(stub, f);
    }

    public void stopReconnecting(final RouterStub stub) {
        Future<?> f = (Future<?>)this.futures.get(stub);
        if (f != null) {
            f.cancel(true);
            this.futures.remove(stub);
        }
        Runnable pinger = new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (RouterStubManager.this.log.isTraceEnabled()) {
                            RouterStubManager.this.log.trace("Pinging " + stub);
                        }
                        stub.checkConnection();
                        if (RouterStubManager.this.log.isTraceEnabled()) {
                            RouterStubManager.this.log.trace("Pinged " + stub);
                        }
                    }
                    catch (Throwable ex) {
                        if (!RouterStubManager.this.log.isWarnEnabled()) break block4;
                        RouterStubManager.this.log.warn("failed pinging stub, GR at " + stub.getGossipRouterAddress() + ": " + ex);
                    }
                }
            }

            public String toString() {
                return RouterStubManager.class.getSimpleName() + ": Pinger";
            }
        };
        f = this.timer.scheduleWithFixedDelay(pinger, 1000L, this.interval, TimeUnit.MILLISECONDS);
        this.futures.putIfAbsent(stub, f);
    }

    @Override
    public void connectionStatusChange(RouterStub stub, RouterStub.ConnectionStatus newState) {
        if (newState == RouterStub.ConnectionStatus.CONNECTION_BROKEN) {
            stub.interrupt();
            stub.destroy();
            this.startReconnecting(stub);
        } else if (newState == RouterStub.ConnectionStatus.CONNECTED) {
            this.stopReconnecting(stub);
        } else if (newState == RouterStub.ConnectionStatus.DISCONNECTED) {
            try {
                stub.join(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static RouterStubManager emptyGossipClientStubManager(Protocol p) {
        return new RouterStubManager(p);
    }
}

