/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingInputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.GIOP.LocateRequestHeader_1_0;
import org.omg.GIOP.LocateRequestHeader_1_0Helper;
import org.omg.GIOP.LocateRequestHeader_1_2;
import org.omg.GIOP.LocateRequestHeader_1_2Helper;
import org.omg.GIOP.RequestHeader_1_0;
import org.omg.GIOP.RequestHeader_1_0Helper;
import org.omg.GIOP.RequestHeader_1_1;
import org.omg.GIOP.RequestHeader_1_1Helper;
import org.omg.GIOP.RequestHeader_1_2;
import org.omg.GIOP.RequestHeader_1_2Helper;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.ServiceContext;

public class RequestInputStream
extends ServiceContextTransportingInputStream {
    private static final byte[] reserved = new byte[3];
    private final boolean is_locate_request;
    public final RequestHeader_1_2 req_hdr;

    public RequestInputStream(ORB orb, byte[] buf) {
        super(orb, buf);
        if (Messages.getMsgType(this.buffer) == 0) {
            switch (this.giop_minor) {
                case 0: {
                    RequestHeader_1_0 hdr = RequestHeader_1_0Helper.read(this);
                    TargetAddress addr = new TargetAddress();
                    addr.object_key(hdr.object_key);
                    this.req_hdr = new RequestHeader_1_2(hdr.request_id, Messages.responseFlags(hdr.response_expected), reserved, addr, hdr.operation, hdr.service_context);
                    break;
                }
                case 1: {
                    RequestHeader_1_1 hdr = RequestHeader_1_1Helper.read(this);
                    TargetAddress addr = new TargetAddress();
                    addr.object_key(hdr.object_key);
                    this.req_hdr = new RequestHeader_1_2(hdr.request_id, Messages.responseFlags(hdr.response_expected), reserved, addr, hdr.operation, hdr.service_context);
                    break;
                }
                case 2: {
                    this.req_hdr = RequestHeader_1_2Helper.read(this);
                    this.skipHeaderPadding();
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown GIOP minor version: " + this.giop_minor);
                }
            }
            this.is_locate_request = false;
        } else if (Messages.getMsgType(this.buffer) == 3) {
            switch (this.giop_minor) {
                case 0: 
                case 1: {
                    LocateRequestHeader_1_0 locate_req_hdr = LocateRequestHeader_1_0Helper.read(this);
                    TargetAddress addr = new TargetAddress();
                    addr.object_key(locate_req_hdr.object_key);
                    this.req_hdr = new RequestHeader_1_2(locate_req_hdr.request_id, 3, reserved, addr, "_non_existent", Messages.service_context);
                    break;
                }
                case 2: {
                    LocateRequestHeader_1_2 locate_req_hdr = LocateRequestHeader_1_2Helper.read(this);
                    this.req_hdr = new RequestHeader_1_2(locate_req_hdr.request_id, 3, reserved, locate_req_hdr.target, "_non_existent", Messages.service_context);
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown GIOP minor version: " + this.giop_minor);
                }
            }
            this.is_locate_request = true;
        } else {
            throw new MARSHAL("Error: not a request!");
        }
    }

    public ServiceContext getServiceContext(int id) {
        for (int i = 0; i < this.req_hdr.service_context.length; ++i) {
            if (this.req_hdr.service_context[i].context_id != id) continue;
            return this.req_hdr.service_context[i];
        }
        return null;
    }

    public boolean isLocateRequest() {
        return this.is_locate_request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

