/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.GSSUPCredentialSpi;
import org.jacorb.security.sas.GSSUPNameSpi;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

public final class GSSUPContextSpi
implements GSSContextSpi {
    private Provider provider = null;
    private Oid mechOid = null;
    private int lifetime;
    private boolean mutualAuth = false;
    private boolean relayDet = false;
    private boolean sequenceDet = false;
    private boolean credDeleg = false;
    private boolean anonymity = false;
    private boolean conf = false;
    private boolean integ = false;
    private boolean established = false;
    private ChannelBinding channelBinding = null;
    private GSSNameSpi targetName;
    private GSSCredentialSpi sourceCred;

    public GSSUPContextSpi(Provider provider, Oid mechOid, GSSNameSpi nameSpi, GSSCredentialSpi credSpi, int lifetime) {
        this.provider = provider;
        this.mechOid = mechOid;
        this.targetName = nameSpi;
        this.sourceCred = credSpi;
        this.lifetime = lifetime;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void requestLifetime(int lifetime) throws GSSException {
        this.lifetime = lifetime;
    }

    public void requestMutualAuth(boolean tf) throws GSSException {
        this.mutualAuth = tf;
    }

    public void requestReplayDet(boolean tf) throws GSSException {
        this.relayDet = tf;
    }

    public void requestSequenceDet(boolean tf) throws GSSException {
        this.sequenceDet = false;
    }

    public void requestCredDeleg(boolean tf) throws GSSException {
        this.credDeleg = tf;
    }

    public void requestAnonymity(boolean tf) throws GSSException {
        this.anonymity = tf;
    }

    public void requestConf(boolean tf) throws GSSException {
        this.conf = tf;
    }

    public void requestInteg(boolean tf) throws GSSException {
        this.integ = tf;
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        this.channelBinding = cb;
    }

    public boolean getCredDelegState() {
        return this.credDeleg;
    }

    public boolean getMutualAuthState() {
        return this.mutualAuth;
    }

    public boolean getReplayDetState() {
        return this.relayDet;
    }

    public boolean getSequenceDetState() {
        return this.sequenceDet;
    }

    public boolean getAnonymityState() {
        return this.anonymity;
    }

    public boolean isTransferable() throws GSSException {
        return true;
    }

    public boolean isProtReady() {
        return false;
    }

    public boolean getConfState() {
        return this.conf;
    }

    public boolean getIntegState() {
        return this.integ;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean isEstablished() {
        return this.established;
    }

    public GSSNameSpi getSrcName() throws GSSException {
        return this.sourceCred.getName();
    }

    public GSSNameSpi getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public GSSCredentialSpi getDelegCred() throws GSSException {
        return null;
    }

    public byte[] initSecContext(InputStream inStream, int inLen) throws GSSException {
        this.established = true;
        return ((Object)this.sourceCred.getName()).toString().getBytes();
    }

    public byte[] acceptSecContext(InputStream inStream, int inLen) throws GSSException {
        this.established = true;
        try {
            byte[] inBytes = new byte[inStream.available()];
            inStream.read(inBytes);
            GSSUPNameSpi sourceName = new GSSUPNameSpi(this.provider, this.mechOid, inBytes, null);
            this.sourceCred = new GSSUPCredentialSpi(this.provider, this.mechOid, sourceName, 0, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getWrapSizeLimit(int i1, boolean b1, int i2) throws GSSException {
        return 0;
    }

    public void wrap(InputStream inStream, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    public byte[] wrap(byte[] b, int i1, int i2, MessageProp mp) throws GSSException {
        return null;
    }

    public int wrap(byte[] b1, int i1, int i2, byte[] b2, int i3, MessageProp mp) throws GSSException {
        return 0;
    }

    public void wrap(byte[] b, int i1, int i2, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    public byte[] unwrap(byte[] b, int i1, int i2, MessageProp mp) throws GSSException {
        return null;
    }

    public int unwrap(byte[] b1, int i1, int i2, byte[] b2, int i3, MessageProp mp) throws GSSException {
        return 0;
    }

    public int unwrap(InputStream inStream, byte[] b, int i1, MessageProp mp) throws GSSException {
        return 0;
    }

    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    public byte[] getMIC(byte[] b1, int i1, int i2, MessageProp mp) throws GSSException {
        return null;
    }

    public void verifyMIC(InputStream inStream1, InputStream inStream2, MessageProp mp) throws GSSException {
    }

    public void verifyMIC(byte[] b1, int i1, int i2, byte[] b2, int i3, int i4, MessageProp mp) throws GSSException {
    }

    public byte[] export() throws GSSException {
        return null;
    }

    public void dispose() throws GSSException {
        this.channelBinding = null;
        this.provider = null;
        this.mechOid = null;
    }

    public boolean isInitiator() {
        return false;
    }
}

