/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Creator;
import org.jboss.as.clustering.infinispan.invoker.Locator;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.CacheEntryMutator;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionCacheEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesCacheKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class CoarseSessionFactory<L>
implements SessionFactory<CoarseSessionEntry<L>, L> {
    private final SessionContext context;
    private final Cache<String, CoarseSessionCacheEntry<L>> sessionCache;
    private final Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache;
    private final CacheInvoker invoker;
    private final SessionAttributeMarshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSessionFactory(Cache<String, CoarseSessionCacheEntry<L>> sessionCache, Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache, CacheInvoker invoker, SessionContext context, SessionAttributeMarshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.sessionCache = sessionCache;
        this.attributesCache = attributesCache;
        this.invoker = invoker;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, CoarseSessionEntry<L> entry) {
        CoarseSessionCacheEntry<L> cacheEntry = entry.getCacheEntry();
        SessionMetaData metaData = cacheEntry.getMetaData();
        MarshalledValue<Map<String, Object>, MarshallingContext> value = entry.getAttributes();
        Mutator attributesMutator = metaData.isNew() ? Mutator.PASSIVE : new CacheEntryMutator<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>>(this.attributesCache, this.invoker, new SessionAttributesCacheKey(id), value, Flag.SKIP_LOCKING);
        CoarseSessionAttributes attributes = new CoarseSessionAttributes(value, this.marshaller, attributesMutator);
        Mutator sessionMutator = metaData.isNew() ? Mutator.PASSIVE : new CacheEntryMutator<String, CoarseSessionCacheEntry<L>>(this.sessionCache, this.invoker, id, cacheEntry, new Flag[0]);
        return new InfinispanSession<L>(id, metaData, attributes, cacheEntry.getLocalContext(), this.localContextFactory, this.context, sessionMutator, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, CoarseSessionEntry<L> entry) {
        CoarseSessionCacheEntry<L> cacheEntry = entry.getCacheEntry();
        SessionMetaData metaData = cacheEntry.getMetaData();
        MarshalledValue<Map<String, Object>, MarshallingContext> value = entry.getAttributes();
        CoarseImmutableSessionAttributes attributes = new CoarseImmutableSessionAttributes(value, this.marshaller);
        return new InfinispanImmutableSession(id, (ImmutableSessionMetaData)metaData, attributes, this.context);
    }

    public CoarseSessionEntry<L> createValue(String id) {
        CoarseSessionCacheEntry cacheEntry = new CoarseSessionCacheEntry(new SimpleSessionMetaData());
        CoarseSessionCacheEntry existingCacheEntry = (CoarseSessionCacheEntry)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)new Creator.CreateOperation((Object)id, cacheEntry), new Flag[0]);
        if (existingCacheEntry != null) {
            MarshalledValue value = (MarshalledValue)this.invoker.invoke(this.attributesCache, (CacheInvoker.Operation)new Locator.FindOperation((Object)new SessionAttributesCacheKey(id)), new Flag[]{Flag.SKIP_LOCKING});
            return new CoarseSessionEntry(existingCacheEntry, (MarshalledValue<Map<String, Object>, MarshallingContext>)value);
        }
        HashMap map = new HashMap();
        MarshalledValue<Map<String, Object>, MarshallingContext> value = this.marshaller.write(map);
        MarshalledValue<Map<String, Object>, MarshallingContext> existingValue = (MarshalledValue<Map<String, Object>, MarshallingContext>)this.invoker.invoke(this.attributesCache, (CacheInvoker.Operation)new Creator.CreateOperation((Object)new SessionAttributesCacheKey(id), value), new Flag[]{Flag.SKIP_LOCKING});
        return new CoarseSessionEntry(cacheEntry, existingValue != null ? existingValue : value);
    }

    public CoarseSessionEntry<L> findValue(String id) {
        CoarseSessionCacheEntry entry = (CoarseSessionCacheEntry)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)new Locator.LockingFindOperation((Object)id), new Flag[0]);
        if (entry == null) {
            return null;
        }
        MarshalledValue value = (MarshalledValue)this.invoker.invoke(this.attributesCache, (CacheInvoker.Operation)new Locator.FindOperation((Object)new SessionAttributesCacheKey(id)), new Flag[]{Flag.SKIP_LOCKING});
        return new CoarseSessionEntry(entry, (MarshalledValue<Map<String, Object>, MarshallingContext>)value);
    }

    public void remove(String id) {
        this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)id), new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.invoker.invoke(this.attributesCache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)new SessionAttributesCacheKey(id)), new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LOCKING});
    }

    public void evict(String id) {
        try {
            this.sessionCache.evict((Object)id);
            this.attributesCache.evict((Object)new SessionAttributesCacheKey(id));
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }
}

