/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.iteration.impl.RemovableEntryIterator;
import org.infinispan.transaction.impl.LocalTransaction;

public class TransactionAwareCloseableIterator<K, V, C>
extends RemovableEntryIterator<K, V, C> {
    private final TxInvocationContext<LocalTransaction> ctx;
    private final List<CacheEntry> contextEntries;
    private final Set<Object> seenContextKeys = new HashSet<Object>();
    private final KeyValueFilter<? super K, ? super V> filter;
    private final Converter<? super K, ? super V, ? extends C> converter;
    private final boolean filterAndConvert;
    private final InternalEntryFactory entryFactory;

    public TransactionAwareCloseableIterator(CloseableIterator<CacheEntry<K, V>> realIterator, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter, TxInvocationContext<LocalTransaction> ctx, Cache<K, V> cache) {
        super(realIterator, cache, false);
        this.ctx = ctx;
        this.filter = filter;
        if (filter instanceof KeyValueFilterConverter && (filter == converter || converter == null)) {
            this.filterAndConvert = true;
            this.converter = null;
        } else {
            this.filterAndConvert = false;
            this.converter = converter;
        }
        this.entryFactory = cache.getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        this.contextEntries = new ArrayList<CacheEntry>(ctx.getLookedUpEntries().values());
        this.currentValue = this.getNextFromIterator();
    }

    protected CacheEntry<K, V> filterEntry(CacheEntry<K, V> entry) {
        if (this.filterAndConvert) {
            K key = entry.getKey();
            Object converted = ((KeyValueFilterConverter)this.filter).filterAndConvert(key, entry.getValue(), entry.getMetadata());
            if (converted != null) {
                entry = this.entryFactory.create(entry);
                entry.setValue(converted);
                return entry;
            }
        } else if (this.filter == null || this.filter.accept(entry.getKey(), entry.getValue(), entry.getMetadata())) {
            return entry;
        }
        return null;
    }

    @Override
    protected CacheEntry<K, C> getNextFromIterator() {
        CacheEntry entry;
        CacheEntry returnedEntry = null;
        while (returnedEntry == null && !this.contextEntries.isEmpty() && (entry = this.contextEntries.remove(0)) != null) {
            this.seenContextKeys.add(entry.getKey());
            if (this.ctx.isEntryRemovedInContext(entry.getKey())) continue;
            returnedEntry = this.filterEntry(entry);
        }
        if (returnedEntry == null) {
            while (this.realIterator.hasNext()) {
                CacheEntry iteratedEntry = (CacheEntry)this.realIterator.next();
                CacheEntry contextEntry = this.ctx.lookupEntry(iteratedEntry.getKey());
                if (contextEntry != null) {
                    if (!this.seenContextKeys.add(contextEntry.getKey()) || contextEntry.isRemoved() || (returnedEntry = this.filterEntry(contextEntry)) == null) continue;
                    break;
                }
                return iteratedEntry;
            }
        }
        if (returnedEntry == null) {
            for (CacheEntry lookedUpEntry : this.ctx.getLookedUpEntries().values()) {
                if (!this.seenContextKeys.add(lookedUpEntry.getKey()) || lookedUpEntry.isRemoved()) continue;
                if (returnedEntry == null) {
                    returnedEntry = lookedUpEntry;
                    continue;
                }
                this.contextEntries.add(lookedUpEntry);
            }
        }
        if (returnedEntry != null && this.converter != null) {
            C newValue = this.converter.convert(returnedEntry.getKey(), returnedEntry.getValue(), returnedEntry.getMetadata());
            returnedEntry = this.entryFactory.create(returnedEntry);
            returnedEntry.setValue(newValue);
        }
        return returnedEntry;
    }
}

