/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml.catalog.readers;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Vector;
import org.jboss.util.xml.catalog.Catalog;
import org.jboss.util.xml.catalog.CatalogEntry;
import org.jboss.util.xml.catalog.CatalogException;
import org.jboss.util.xml.catalog.readers.TextCatalogReader;

public class TR9401CatalogReader
extends TextCatalogReader {
    @Override
    public void readCatalog(Catalog catalog, InputStream is) throws MalformedURLException, IOException {
        this.catfile = is;
        if (this.catfile == null) {
            return;
        }
        Vector<String> unknownEntry = null;
        while (true) {
            String token;
            if ((token = this.nextToken()) == null) {
                if (unknownEntry != null) {
                    catalog.unknownEntry(unknownEntry);
                    unknownEntry = null;
                }
                this.catfile.close();
                this.catfile = null;
                return;
            }
            String entryToken = null;
            entryToken = this.caseSensitive ? token : token.toUpperCase();
            if (entryToken.equals("DELEGATE")) {
                entryToken = "DELEGATE_PUBLIC";
            }
            try {
                int type = CatalogEntry.getEntryType(entryToken);
                int numArgs = CatalogEntry.getEntryArgCount(type);
                Vector<String> args = new Vector<String>();
                if (unknownEntry != null) {
                    catalog.unknownEntry(unknownEntry);
                    unknownEntry = null;
                }
                for (int count = 0; count < numArgs; ++count) {
                    args.addElement(this.nextToken());
                }
                catalog.addEntry(new CatalogEntry(entryToken, args));
                continue;
            }
            catch (CatalogException cex) {
                if (cex.getExceptionType() == 3) {
                    if (unknownEntry == null) {
                        unknownEntry = new Vector<String>();
                    }
                    unknownEntry.addElement(token);
                    continue;
                }
                if (cex.getExceptionType() != 2) continue;
                catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", token);
                unknownEntry = null;
                continue;
            }
            break;
        }
    }
}

