/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerService;
import org.wildfly.extension.mod_cluster.ContextHost;
import org.wildfly.extension.mod_cluster.ModClusterDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterMessages;

public class ModClusterDisableContext
implements OperationStepHandler {
    static final ModClusterDisableContext INSTANCE = new ModClusterDisableContext();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("disable-context", descriptionResolver).addParameter((AttributeDefinition)ModClusterDefinition.VIRTUAL_HOST).addParameter((AttributeDefinition)ModClusterDefinition.CONTEXT).setRuntimeOnly().build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ContainerEventHandlerService.SERVICE_NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ContainerEventHandlerService.SERVICE_NAME);
                    final ModClusterServiceMBean service = (ModClusterServiceMBean)controller.getValue();
                    ModClusterLogger.ROOT_LOGGER.debugf("disable-context: %s", operation);
                    final ContextHost contexthost = new ContextHost(operation);
                    try {
                        service.disableContext(contexthost.webhost, contexthost.webcontext);
                    }
                    catch (IllegalArgumentException e) {
                        throw new OperationFailedException(new ModelNode().set(ModClusterMessages.MESSAGES.ContextorHostNotFound(contexthost.webhost, contexthost.webcontext)));
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            service.enableContext(contexthost.webhost, contexthost.webcontext);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

