/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.csiv2;

import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.csiv2.CSIv2Util;
import org.jboss.as.jacorb.service.CorbaORBService;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.GSSUP.ErrorToken;
import org.omg.GSSUP.ErrorTokenHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SASTargetInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final int sasContextId = 15;
    private static final byte[] empty = new byte[0];
    private static final IdentityToken absent = new IdentityToken();
    private static final SASContextBody msgBodyCtxAccepted;
    private static final Any msgCtx0Accepted;
    private final Codec codec;
    private final SASContextBody msgBodyCtxError;
    private final Any msgCtx0Rejected;
    private ThreadLocal threadLocalData = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new CurrentRequestInfo();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Any createMsgCtxAccepted(long contextId) {
        Any any = ORB.init().create_any();
        SASContextBody sASContextBody = msgBodyCtxAccepted;
        synchronized (sASContextBody) {
            SASTargetInterceptor.msgBodyCtxAccepted.complete_msg().client_context_id = contextId;
            SASContextBodyHelper.insert((Any)any, (SASContextBody)msgBodyCtxAccepted);
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Any createMsgCtxError(long contextId, int majorStatus) {
        Any any = ORB.init().create_any();
        SASContextBody sASContextBody = this.msgBodyCtxError;
        synchronized (sASContextBody) {
            this.msgBodyCtxError.error_msg().client_context_id = contextId;
            this.msgBodyCtxError.error_msg().major_status = majorStatus;
            SASContextBodyHelper.insert((Any)any, (SASContextBody)this.msgBodyCtxError);
        }
        return any;
    }

    public SASTargetInterceptor(Codec codec) {
        byte[] encapsulatedErrorToken;
        this.codec = codec;
        ErrorToken errorToken = new ErrorToken(1);
        Any any = ORB.init().create_any();
        ErrorTokenHelper.insert((Any)any, (ErrorToken)errorToken);
        try {
            encapsulatedErrorToken = codec.encode_value(any);
        }
        catch (InvalidTypeForEncoding e) {
            throw JacORBMessages.MESSAGES.unexpectedException(e);
        }
        ContextError ctxError = new ContextError(0L, 1, 1, encapsulatedErrorToken);
        this.msgBodyCtxError = new SASContextBody();
        this.msgBodyCtxError.error_msg(ctxError);
        this.msgCtx0Rejected = this.createMsgCtxError(0L, 1);
    }

    boolean sasContextReceived() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.sasContextReceived;
    }

    boolean authenticationTokenReceived() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.authenticationTokenReceived;
    }

    byte[] getIncomingUsername() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.incomingUsername;
    }

    byte[] getIncomingPassword() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.incomingPassword;
    }

    byte[] getIncomingTargetName() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.incomingTargetName;
    }

    IdentityToken getIncomingIdentity() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.incomingIdentity;
    }

    byte[] getIncomingPrincipalName() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        return threadLocal.incomingPrincipalName;
    }

    void rejectIncomingContext() {
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        if (threadLocal.sasContextReceived) {
            threadLocal.sasReply = threadLocal.contextId == 0L ? this.msgCtx0Rejected : this.createMsgCtxError(threadLocal.contextId, 1);
            threadLocal.sasReplyIsAccept = false;
        }
    }

    public String name() {
        return "SASTargetInterceptor";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
    }

    public void receive_request(ServerRequestInfo ri) {
        JacORBLogger.ROOT_LOGGER.traceReceiveRequest(ri.operation());
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        threadLocal.sasContextReceived = false;
        threadLocal.authenticationTokenReceived = false;
        threadLocal.incomingUsername = empty;
        threadLocal.incomingPassword = empty;
        threadLocal.incomingTargetName = empty;
        threadLocal.incomingIdentity = absent;
        threadLocal.incomingPrincipalName = empty;
        threadLocal.sasReply = null;
        threadLocal.sasReplyIsAccept = false;
        try {
            ServiceContext sc = ri.get_request_service_context(15);
            Any any = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)any);
            if (contextBody != null) {
                if (contextBody.discriminator() == 5) {
                    long contextId = contextBody.in_context_msg().client_context_id;
                    threadLocal.sasReply = this.createMsgCtxError(contextId, 4);
                    throw JacORBMessages.MESSAGES.missingSASContext();
                }
                if (contextBody.discriminator() == 0) {
                    EstablishContext message = contextBody.establish_msg();
                    threadLocal.contextId = message.client_context_id;
                    threadLocal.sasContextReceived = true;
                    if (message.client_authentication_token != null && message.client_authentication_token.length > 0) {
                        JacORBLogger.ROOT_LOGGER.authTokenReceived();
                        InitialContextToken authToken = CSIv2Util.decodeInitialContextToken(message.client_authentication_token, this.codec);
                        if (authToken == null) {
                            threadLocal.sasReply = this.createMsgCtxError(message.client_context_id, 2);
                            throw JacORBMessages.MESSAGES.errorDecodingInitContextToken();
                        }
                        threadLocal.incomingUsername = authToken.username;
                        threadLocal.incomingPassword = authToken.password;
                        threadLocal.incomingTargetName = CSIv2Util.decodeGssExportedName(authToken.target_name);
                        if (threadLocal.incomingTargetName == null) {
                            threadLocal.sasReply = this.createMsgCtxError(message.client_context_id, 2);
                            throw JacORBMessages.MESSAGES.errorDecodingTargetInContextToken();
                        }
                        threadLocal.authenticationTokenReceived = true;
                    }
                    if (message.identity_token != null) {
                        JacORBLogger.ROOT_LOGGER.identityTokenReceived();
                        threadLocal.incomingIdentity = message.identity_token;
                        if (message.identity_token.discriminator() == 2) {
                            Any a = this.codec.decode_value(message.identity_token.principal_name(), GSS_NT_ExportedNameHelper.type());
                            byte[] encodedName = GSS_NT_ExportedNameHelper.extract((Any)a);
                            threadLocal.incomingPrincipalName = CSIv2Util.decodeGssExportedName(encodedName);
                            if (threadLocal.incomingPrincipalName == null) {
                                threadLocal.sasReply = this.createMsgCtxError(message.client_context_id, 2);
                                throw JacORBMessages.MESSAGES.errorDecodingPrincipalName();
                            }
                        }
                    }
                    threadLocal.sasReply = threadLocal.contextId == 0L ? msgCtx0Accepted : SASTargetInterceptor.createMsgCtxAccepted(threadLocal.contextId);
                    threadLocal.sasReplyIsAccept = true;
                }
            }
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw JacORBMessages.MESSAGES.errorDecodingContextData(this.name(), e);
        }
        catch (TypeMismatch e) {
            throw JacORBMessages.MESSAGES.errorDecodingContextData(this.name(), e);
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        JacORBLogger.ROOT_LOGGER.traceSendReply(ri.operation());
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        if (threadLocal.sasReply != null) {
            try {
                ServiceContext sc = new ServiceContext(15, this.codec.encode_value(threadLocal.sasReply));
                ri.add_reply_service_context(sc, true);
            }
            catch (InvalidTypeForEncoding e) {
                throw JacORBMessages.MESSAGES.unexpectedException(e);
            }
        }
    }

    public void send_exception(ServerRequestInfo ri) {
        JacORBLogger.ROOT_LOGGER.traceSendException(ri.operation());
        CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
        boolean interopIONA = "on".equalsIgnoreCase(CorbaORBService.getORBProperty("iona"));
        if (threadLocal.sasReply != null && !interopIONA) {
            try {
                ServiceContext sc = new ServiceContext(15, this.codec.encode_value(threadLocal.sasReply));
                ri.add_reply_service_context(sc, true);
            }
            catch (InvalidTypeForEncoding e) {
                throw JacORBMessages.MESSAGES.unexpectedException(e);
            }
        }
    }

    public void send_other(ServerRequestInfo ri) {
    }

    static {
        absent.absent(true);
        CompleteEstablishContext ctxAccepted = new CompleteEstablishContext(0L, false, new byte[0]);
        msgBodyCtxAccepted = new SASContextBody();
        msgBodyCtxAccepted.complete_msg(ctxAccepted);
        msgCtx0Accepted = SASTargetInterceptor.createMsgCtxAccepted(0L);
    }

    private static class CurrentRequestInfo {
        boolean sasContextReceived;
        boolean authenticationTokenReceived;
        byte[] incomingUsername;
        byte[] incomingPassword;
        byte[] incomingTargetName;
        IdentityToken incomingIdentity;
        byte[] incomingPrincipalName;
        long contextId;
        Any sasReply;
        boolean sasReplyIsAccept;

        CurrentRequestInfo() {
        }
    }
}

