/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.as.jacorb.csiv2.idl.SASCurrent;
import org.jboss.security.auth.callback.SecurityAssociationCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class TrustedIdentityTokenLoginModule
extends AbstractServerLoginModule {
    private Principal identity;
    private SASCurrent credential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        String username;
        if (super.login()) {
            Object username2 = this.sharedState.get("javax.security.auth.login.name");
            if (username2 instanceof Principal) {
                this.identity = (Principal)username2;
            } else {
                String name = username2.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    LoginException le = new LoginException();
                    le.initCause(e);
                    throw le;
                }
            }
            return true;
        }
        this.loginOk = false;
        if (this.callbackHandler == null) {
            throw new LoginException();
        }
        SecurityAssociationCallback callback = new SecurityAssociationCallback();
        Callback[] callbacks = new Callback[]{callback};
        try {
            this.callbackHandler.handle(callbacks);
            username = callback.getPrincipal().getName();
            Object c = callback.getCredential();
            if (!(c instanceof SASCurrent)) {
                return false;
            }
            this.credential = (SASCurrent)c;
        }
        catch (IOException e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        catch (UnsupportedCallbackException e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        this.validateCredential(username, this.credential);
        if (username == null) {
            return false;
        }
        if (this.identity == null) {
            try {
                this.identity = this.createIdentity(username);
            }
            catch (Exception e) {
                LoginException le = new LoginException();
                le.initCause(e);
                throw le;
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.identity);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        return true;
    }

    protected void validateCredential(String username, SASCurrent credential) throws LoginException {
        if (credential.get_incoming_principal_name() == null || credential.get_incoming_principal_name().length == 0) {
            throw new LoginException();
        }
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

