/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.tm;

import javax.transaction.Transaction;
import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.tm.ForeignTransaction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class TxServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    static final long serialVersionUID = 7474707114565659371L;
    private static final int txContextId = 0;
    private static int slotId;
    private static Codec codec;
    private static Current piCurrent;

    static void init(int slotId, Codec codec, Current piCurrent) {
        TxServerInterceptor.slotId = slotId;
        TxServerInterceptor.codec = codec;
        TxServerInterceptor.piCurrent = piCurrent;
    }

    public static Transaction getCurrentTransaction() {
        ForeignTransaction tx = null;
        if (piCurrent != null) {
            try {
                Any any = piCurrent.get_slot(slotId);
                if (any.type().kind().value() != 0) {
                    tx = ForeignTransaction.INSTANCE;
                }
            }
            catch (InvalidSlot e) {
                throw JacORBMessages.MESSAGES.errorGettingSlotInTxInterceptor(e);
            }
        }
        return tx;
    }

    public String name() {
        return "TxServerInterceptor";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        JacORBLogger.ROOT_LOGGER.traceReceiveRequestServiceContexts(ri.operation());
        try {
            ServiceContext sc = ri.get_request_service_context(0);
            Any any = codec.decode_value(sc.context_data, PropagationContextHelper.type());
            ri.set_slot(slotId, any);
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw JacORBMessages.MESSAGES.errorDecodingContextData(this.name(), e);
        }
        catch (TypeMismatch e) {
            throw JacORBMessages.MESSAGES.errorDecodingContextData(this.name(), e);
        }
        catch (InvalidSlot e) {
            throw JacORBMessages.MESSAGES.errorSettingSlotInTxInterceptor(e);
        }
    }

    public void receive_request(ServerRequestInfo ri) {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) {
    }

    public void send_other(ServerRequestInfo ri) {
    }

    static {
        piCurrent = null;
    }
}

