/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FilterDef {
    private static final Log LOG = LoggerFactory.make();
    private Method factoryMethod;
    private Method keyMethod;
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final FilterCacheModeType cacheMode;
    private final Class<?> impl;
    private final String name;

    public FilterDef(FullTextFilterDef def) {
        this.name = def.name();
        this.impl = def.impl();
        this.cacheMode = def.cache();
    }

    public String getName() {
        return this.name;
    }

    public FilterCacheModeType getCacheMode() {
        return this.cacheMode;
    }

    public Class<?> getImpl() {
        return this.impl;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(Method factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public Method getKeyMethod() {
        return this.keyMethod;
    }

    public void setKeyMethod(Method keyMethod) {
        this.keyMethod = keyMethod;
    }

    public void addSetter(String name, Method method) {
        ReflectionHelper.setAccessible(method);
        this.setters.put(name, method);
    }

    public void invoke(String parameterName, Object filter, Object parameterValue) {
        Method method = this.setters.get(parameterName);
        if (method == null) {
            throw new SearchException("No setter " + parameterName + " found in " + this.impl);
        }
        try {
            method.invoke(filter, parameterValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw LOG.unableToSetFilterParameter(this.impl, parameterName, e);
        }
    }

    public String toString() {
        return "FilterDef [name=" + this.name + ", impl=" + this.impl + ", cacheMode=" + (Object)((Object)this.cacheMode) + ", factoryMethod=" + (this.factoryMethod != null ? this.factoryMethod.getName() : null) + ", keyMethod=" + (this.keyMethod != null ? this.keyMethod.getName() : null) + ", setters=" + this.setters.keySet() + "]";
    }
}

