/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.nio.ByteBuffer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.VersionedValueImpl;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.BoundedConcurrentMapNearCache;
import org.infinispan.client.hotrod.near.ConcurrentMapNearCache;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public class NearCacheService<K, V>
implements NearCache<K, V> {
    private static final Log log = LogFactory.getLog(NearCacheService.class);
    private final NearCacheConfiguration config;
    private final ClientListenerNotifier listenerNotifier;
    private Object listener;
    private byte[] listenerId;
    private NearCache<K, V> cache;

    protected NearCacheService(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        this.config = config;
        this.listenerNotifier = listenerNotifier;
    }

    public void start(RemoteCache<K, V> remote) {
        this.cache = this.createNearCache(this.config);
        this.listener = this.createListener(remote);
        remote.addClientListener(this.listener);
        this.listenerId = this.listenerNotifier.findListenerId(this.listener);
    }

    private Object createListener(RemoteCache<K, V> remote) {
        return this.config.mode().eager() ? new EagerNearCacheListener(this, remote.getRemoteCacheManager().getMarshaller()) : new LazyNearCacheListener(this);
    }

    public void stop(RemoteCache<K, V> remote) {
        if (log.isTraceEnabled()) {
            log.tracef("Stop near cache, remove underlying listener id %s", Util.printArray((byte[])this.listenerId));
        }
        remote.removeClientListener(this.listener);
        this.cache.clear();
    }

    protected NearCache<K, V> createNearCache(NearCacheConfiguration config) {
        return config.maxEntries() > 0 ? BoundedConcurrentMapNearCache.create(config) : ConcurrentMapNearCache.create();
    }

    public static <K, V> NearCacheService<K, V> create(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        return new NearCacheService<K, V>(config, listenerNotifier);
    }

    @Override
    public void put(K key, VersionedValue<V> value) {
        this.cache.put(key, value);
        if (log.isTraceEnabled()) {
            log.tracef("Put key=%s and value=%s in near cache (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public void putIfAbsent(K key, VersionedValue<V> value) {
        this.cache.putIfAbsent(key, value);
        if (log.isTraceEnabled()) {
            log.tracef("Conditionally put key=%s and value=%s if absent in near cache (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
        if (log.isTraceEnabled()) {
            log.tracef("Removed key=%s from near cache (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public VersionedValue<V> get(K key) {
        boolean listenerConnected = this.isConnected();
        if (listenerConnected) {
            VersionedValue<V> value = this.cache.get(key);
            if (log.isTraceEnabled()) {
                log.tracef("Get key=%s returns value=%s (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
            }
            return value;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Near cache disconnected from server, returning null for key=%s (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
        if (log.isTraceEnabled()) {
            log.tracef("Cleared near cache (listenerId=%s)", Util.printArray((byte[])this.listenerId));
        }
    }

    private boolean isConnected() {
        return this.listenerNotifier.isListenerConnected(this.listenerId);
    }

    @ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
    private static class EagerNearCacheListener<K, V> {
        private static final Log log = LogFactory.getLog(EagerNearCacheListener.class);
        private final NearCache<K, V> cache;
        private final Marshaller marshaller;

        private EagerNearCacheListener(NearCache<K, V> cache, Marshaller marshaller) {
            this.cache = cache;
            this.marshaller = marshaller;
        }

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        public void handleCreatedModifiedEvent(ClientCacheEntryCustomEvent<byte[]> e) {
            ByteBuffer in = ByteBuffer.wrap(e.getEventData());
            byte[] keyBytes = EagerNearCacheListener.extractElement(in);
            byte[] valueBytes = EagerNearCacheListener.extractElement(in);
            Object key = this.unmarshallObject(keyBytes, "key");
            Object value = this.unmarshallObject(valueBytes, "value");
            long version = in.getLong();
            if (key != null && value != null) {
                VersionedValueImpl entry = new VersionedValueImpl(version, value);
                this.cache.put(key, entry);
            }
        }

        private <T> T unmarshallObject(byte[] bytes, String element) {
            try {
                return (T)this.marshaller.objectFromByteBuffer(bytes);
            }
            catch (Exception e) {
                log.unableToUnmarshallBytesError(element, Util.toStr((Object)bytes), e);
                return null;
            }
        }

        @ClientCacheEntryRemoved
        public void handleRemovedEvent(ClientCacheEntryCustomEvent<byte[]> e) {
            ByteBuffer in = ByteBuffer.wrap(e.getEventData());
            byte[] keyBytes = EagerNearCacheListener.extractElement(in);
            Object key = this.unmarshallObject(keyBytes, "key");
            if (key != null) {
                this.cache.remove(key);
            }
        }

        @ClientCacheFailover
        public void handleFailover(ClientCacheFailoverEvent e) {
            if (log.isTraceEnabled()) {
                log.trace("Clear near cache after fail-over of server");
            }
            this.cache.clear();
        }

        private static byte[] extractElement(ByteBuffer in) {
            int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)in);
            byte[] element = new byte[length];
            in.get(element);
            return element;
        }
    }

    @ClientListener
    private static class LazyNearCacheListener<K, V> {
        private static final Log log = LogFactory.getLog(LazyNearCacheListener.class);
        private final NearCache<K, V> cache;

        private LazyNearCacheListener(NearCache<K, V> cache) {
            this.cache = cache;
        }

        @ClientCacheEntryCreated
        public void handleCreatedEvent(ClientCacheEntryCreatedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryModified
        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryRemoved
        public void handleRemovedEvent(ClientCacheEntryRemovedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheFailover
        public void handleFailover(ClientCacheFailoverEvent e) {
            if (log.isTraceEnabled()) {
                log.trace("Clear near cache after fail-over of server");
            }
            this.cache.clear();
        }

        private void invalidate(K key) {
            this.cache.remove(key);
        }
    }
}

