/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.websockets.client.WebSocket13ClientHandshake;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.http.ExtendedHandshakeChecker;

public abstract class WebSocketClientHandshake {
    protected final URI url;

    public static WebSocketClientHandshake create(WebSocketVersion version, URI uri) {
        return WebSocketClientHandshake.create(version, uri, null);
    }

    public static WebSocketClientHandshake create(WebSocketVersion version, URI uri, WebSocketClientNegotiation clientNegotiation) {
        switch (version) {
            case V13: {
                return new WebSocket13ClientHandshake(uri, clientNegotiation);
            }
        }
        throw new IllegalArgumentException();
    }

    public WebSocketClientHandshake(URI url) {
        this.url = url;
    }

    public abstract WebSocketChannel createChannel(StreamConnection var1, String var2, Pool<ByteBuffer> var3);

    public abstract Map<String, String> createHeaders();

    public abstract ExtendedHandshakeChecker handshakeChecker(URI var1, Map<String, List<String>> var2);
}

