/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.version;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.jboss.as.version.Version;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ProductConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String consoleSlot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ProductConfig(ModuleLoader loader, String home, Map<?, ?> providedProperties) {
        String productName = null;
        String productVersion = null;
        String consoleSlot = null;
        FileReader reader = null;
        try {
            reader = new FileReader(ProductConfig.getProductConf(home));
            Properties props = new Properties();
            props.load(reader);
            String slot = (String)props.get("slot");
            if (slot != null) {
                Module module = loader.loadModule(ModuleIdentifier.create((String)"org.jboss.as.product", (String)slot));
                InputStream stream = module.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
                Manifest manifest = null;
                if (stream != null) {
                    manifest = new Manifest(stream);
                }
                if (manifest != null) {
                    productName = manifest.getMainAttributes().getValue("JBoss-Product-Release-Name");
                    productVersion = manifest.getMainAttributes().getValue("JBoss-Product-Release-Version");
                    consoleSlot = manifest.getMainAttributes().getValue("JBoss-Product-Console-Slot");
                }
            }
            this.setSystemProperties(props, providedProperties);
        }
        catch (Exception e) {
            ProductConfig.safeClose(reader);
            catch (Throwable throwable) {
                ProductConfig.safeClose(reader);
                throw throwable;
            }
        }
        ProductConfig.safeClose(reader);
        this.name = productName;
        this.version = productVersion;
        this.consoleSlot = consoleSlot;
    }

    private static String getProductConf(String home) {
        final String defaultVal = home + File.separator + "bin" + File.separator + "product.conf";
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                String env = System.getenv("JBOSS_PRODUCT_CONF");
                if (env == null) {
                    env = defaultVal;
                }
                return env;
            }
        };
        return System.getSecurityManager() == null ? (String)action.run() : AccessController.doPrivileged(action);
    }

    public ProductConfig(String productName, String productVersion, String consoleSlot) {
        this.name = productName;
        this.version = productVersion;
        this.consoleSlot = consoleSlot;
    }

    public String getProductName() {
        return this.name;
    }

    public String getProductVersion() {
        return this.version;
    }

    public String getConsoleSlot() {
        return this.consoleSlot;
    }

    public String getPrettyVersionString() {
        if (this.name != null) {
            return String.format("JBoss %s %s (WildFly %s)", this.name, this.version, Version.AS_VERSION);
        }
        return String.format("WildFly %s \"%s\"", Version.AS_VERSION, Version.AS_RELEASE_CODENAME);
    }

    public String resolveVersion() {
        return this.version != null ? this.version : Version.AS_VERSION;
    }

    public String resolveName() {
        return this.name != null ? this.name : "WildFly";
    }

    public static String getPrettyVersionString(String name, String version1, String version2) {
        if (name != null) {
            return String.format("JBoss %s %s (WildFly %s)", name, version1, version2);
        }
        return String.format("WildFly %s \"%s\"", version1, version2);
    }

    private void setSystemProperties(final Properties propConfProps, final Map providedProperties) {
        if (propConfProps.size() == 0) {
            return;
        }
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Map.Entry<Object, Object> entry : propConfProps.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("slot") || System.getProperty(key) != null) continue;
                    System.setProperty(key, (String)entry.getValue());
                    providedProperties.put(key, entry.getValue());
                }
                return null;
            }
        };
        if (System.getSecurityManager() == null) {
            action.run();
        } else {
            AccessController.doPrivileged(action);
        }
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

