/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos.wb;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.demos.wb.Node;
import org.jgroups.demos.wb.SendDialog;
import org.jgroups.demos.wb.Whiteboard;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class GraphPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    final Whiteboard wb;
    final List<Node> nodes = new ArrayList<Node>();
    String myname = null;
    public Object my_addr = null;
    Node pick;
    boolean pickfixed;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    static final Color fixedColor = Color.red;
    static final Color selectColor = Color.pink;
    final Color nodeColor = new Color(250, 220, 100);
    final Font default_font = new Font("Helvetica", 0, 12);
    Log log = LogFactory.getLog(this.getClass());

    private Frame findParent() {
        for (Container retval = this.getParent(); retval != null; retval = retval.getParent()) {
            if (!(retval instanceof Frame)) continue;
            return (Frame)retval;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node findNodeAtPoint(Point p) {
        int x = p.x;
        int y = p.y;
        List<Node> list = this.nodes;
        synchronized (list) {
            if (this.nodes.size() < 1) {
                return null;
            }
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                Node n = this.nodes.get(i);
                if (x < n.xloc || x > n.xloc + n.width || y < n.yloc || y > n.yloc + n.height) continue;
                return n;
            }
        }
        return null;
    }

    public GraphPanel(Whiteboard wb) {
        this.wb = wb;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addNode(String lbl, Address addr, int xloc, int yloc) {
        Node n = new Node();
        n.x = xloc;
        n.y = yloc;
        n.lbl = lbl;
        n.addr = addr;
        this.nodes.add(n);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Object addr) {
        if (addr == null) {
            this.log.error("removeNode(): address of node to be removed is null !");
            return;
        }
        List<Node> list = this.nodes;
        synchronized (list) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node n = this.nodes.get(i);
                Address a = n.addr;
                if (a == null || !addr.equals(a)) continue;
                this.nodes.remove(n);
                System.out.println("Removed node " + n);
                break;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustNodes(List<Address> v) {
        boolean removed = false;
        List<Node> list = this.nodes;
        synchronized (list) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node n = this.nodes.get(i);
                if (v.contains(n.addr)) continue;
                System.out.println("adjustNodes(): node " + n + " was removed");
                this.nodes.remove(n);
                removed = true;
            }
            if (removed) {
                this.repaint();
            }
        }
    }

    public void paintNode(Graphics g, Node n, FontMetrics fm) {
        String addr = n.addr != null ? n.addr.toString() : null;
        int x = (int)n.x;
        int y = (int)n.y;
        g.setColor(n == this.pick ? selectColor : (n.fixed ? fixedColor : this.nodeColor));
        int w = fm.stringWidth(n.lbl) + 10;
        if (addr != null) {
            w = Math.max(w, fm.stringWidth(addr) + 10);
        }
        if (addr == null) {
            addr = "<no address>";
        }
        int h = (fm.getHeight() + 4) * 2;
        n.width = w;
        n.height = h;
        n.xloc = x - w / 2;
        n.yloc = y - h / 2;
        g.fillRect(x - w / 2, y - h / 2, w, h);
        g.setColor(Color.black);
        g.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
        g.drawString(n.lbl, x - (w - 10) / 2, y - (h - 4) / 2 + fm.getAscent());
        g.drawString(addr, x - (w - 10) / 2, y - (h - 4) / 2 + 2 * fm.getAscent() + 4);
    }

    @Override
    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.default_font);
        }
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        FontMetrics fm = this.offgraphics.getFontMetrics();
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.paintNode(this.offgraphics, this.nodes.get(i), fm);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        if (this.pick == null) {
            return;
        }
        this.pick.x = p.x;
        this.pick.y = p.y;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        double bestdist = Double.MAX_VALUE;
        int mod = e.getModifiers();
        if ((mod & 4) != 0) {
            System.out.println("\nright button at " + p);
            Node n = this.findNodeAtPoint(p);
            if (n != null) {
                System.out.println("Found node at " + p + ": " + n);
                new SendDialog(this.findParent(), n, this.myname, this.wb.disp);
                this.repaint();
            }
            e.consume();
            return;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node n = this.nodes.get(i);
            double dist = (n.x - (double)p.x) * (n.x - (double)p.x) + (n.y - (double)p.y) * (n.y - (double)p.y);
            if (!(dist < bestdist)) continue;
            this.pick = n;
            bestdist = dist;
        }
        this.pickfixed = this.pick.fixed;
        this.pick.fixed = true;
        this.pick.x = p.x;
        this.pick.y = p.y;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
        if (this.pick == null) {
            return;
        }
        this.pick.x = p.x;
        this.pick.y = p.y;
        this.pick.fixed = this.pickfixed;
        try {
            MethodCall call = new MethodCall("moveNode", new Object[]{this.pick}, new Class[]{Node.class});
            this.wb.disp.callRemoteMethods(null, call, new RequestOptions(ResponseMode.GET_ALL, 0L));
        }
        catch (Exception ex) {
            this.log.error(ex.toString());
        }
        this.pick = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void start(String name) {
        this.myname = name;
        int xloc = (int)(10.0 + 250.0 * Math.random());
        int yloc = (int)(10.0 + 250.0 * Math.random());
        try {
            MethodCall call = new MethodCall("addNode", new Object[]{name, this.my_addr, new Integer(xloc), new Integer(yloc)}, new Class[]{String.class, Address.class, Integer.TYPE, Integer.TYPE});
            this.wb.disp.callRemoteMethods(null, call, new RequestOptions(ResponseMode.GET_ALL, 0L));
        }
        catch (Exception e) {
            this.log.error(e.toString());
        }
        this.repaint();
    }

    public void stop() {
        this.nodes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream output) throws Exception {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(output, 1000));
        try {
            List<Node> list = this.nodes;
            synchronized (list) {
                Util.objectToStream(this.nodes, out);
            }
        }
        finally {
            Util.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream input) throws Exception {
        List copy = (List)Util.objectFromStream(new DataInputStream(input));
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.clear();
            this.nodes.addAll(copy);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveNode(Node n) {
        boolean changed = false;
        List<Node> list = this.nodes;
        synchronized (list) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node tmp = this.nodes.get(i);
                if (!n.addr.equals(tmp.addr)) continue;
                tmp.x = n.x;
                tmp.y = n.y;
                changed = true;
                break;
            }
            if (changed) {
                this.repaint();
            }
        }
    }
}

