/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import org.apache.lucene.facet.search.FloatArrayAllocator;
import org.apache.lucene.facet.search.IntArrayAllocator;

public class FacetArrays {
    private int[] intArray;
    private float[] floatArray;
    private IntArrayAllocator intArrayAllocator;
    private FloatArrayAllocator floatArrayAllocator;
    private int arraysLength;

    public FacetArrays(IntArrayAllocator intArrayAllocator, FloatArrayAllocator floatArrayAllocator) {
        this.intArrayAllocator = intArrayAllocator;
        this.floatArrayAllocator = floatArrayAllocator;
    }

    public void free() {
        if (this.intArrayAllocator != null) {
            this.intArrayAllocator.free(this.intArray);
            this.intArray = null;
        }
        if (this.floatArrayAllocator != null) {
            this.floatArrayAllocator.free(this.floatArray);
            this.floatArray = null;
        }
        this.arraysLength = 0;
    }

    public int[] getIntArray() {
        if (this.intArray == null) {
            this.intArray = (int[])this.intArrayAllocator.allocate();
            this.arraysLength = this.intArray.length;
        }
        return this.intArray;
    }

    public float[] getFloatArray() {
        if (this.floatArray == null) {
            this.floatArray = (float[])this.floatArrayAllocator.allocate();
            this.arraysLength = this.floatArray.length;
        }
        return this.floatArray;
    }

    public int getArraysLength() {
        return this.arraysLength;
    }
}

